# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

### Added
- SECURITY.md and CONTRIBUTING.md documentation
- Expanded opencode/agents.md support beyond Claude Code

### Changed
- Enhanced README with clearer usage patterns

## [1.0.0] - 2026-01-XX

### Added
- Initial release of SOTA Tracker
- Daily automated scraping from LMArena, Artificial Analysis, HuggingFace
- REST API with rate limiting
- MCP server support for Claude Code
- SQLite database with 156+ curated SOTA models
- Hardware-aware model recommendations
- Forbidden/outdated model list
- JSON and CSV exports
- GitHub Actions for daily updates
- Weekly tagged releases

### Features

#### Data Sources
- LMArena Elo rankings (6M+ human votes)
- Artificial Analysis LLM benchmarks
- HuggingFace Open LLM Leaderboard
- Manual curation for video/image/audio models

#### Models Tracked (11 categories)
- **LLM Local**: Qwen3, Llama 3.3, DeepSeek-V3, etc.
- **LLM API**: Claude, GPT-4, Gemini, Grok
- **LLM Coding**: Qwen3-Coder, DeepSeek-Coder
- **Image Generation**: FLUX.2-dev, Z-Image-Turbo, Qwen-Image
- **Video Generation**: LTX-2, Wan 2.2, HunyuanVideo
- **Video-to-Audio**: MMAudio V2
- **Text-to-Speech**: ChatterboxTTS, F5-TTS
- **Speech-to-Text**: Whisper Large v3
- **3D Generation**: Meshy-4, Tripo 2.0
- **Embeddings**: BGE-M3, GTE-Qwen2

#### API Endpoints
- `GET /api/v1/models?category=X` - Query SOTA models
- `GET /api/v1/models/:name/freshness` - Check if model is current
- `GET /api/v1/forbidden` - List outdated models
- `GET /api/v1/compare` - Compare two models
- `GET /api/v1/recent` - Recently released models
- `GET /api/v1/recommend?task=X` - Get recommendations
- `GET /api/v1/hardware/models` - Hardware-aware filtering

#### MCP Tools
- `query_sota(category)` - Get current SOTA models
- `check_freshness(model)` - Verify model is current
- `get_forbidden()` - List forbidden models
- `compare_models(a, b)` - Compare models
- `recent_releases(days)` - Recent releases
- `configure_hardware()` - Set GPU profile
- `query_sota_for_hardware(category)` - Hardware-aware queries
- `get_model_recommendation(task)` - Get best model for task
- `get_best_in_class()` - Get best models per subcategory
- `refresh_data()` - Force refresh data
- `cache_status()` - Check data freshness

#### Hardware Profiles
- Auto-detect GPU VRAM
- Concurrent workload estimation (image_gen, video_gen, comfyui, gaming)
- Uncensored/unfiltered model preferences
- Local-first vs API-first preferences
- Cost-sensitive recommendations

### Security
- No secrets in code base
- User-specific data in `.gitignore` (hardware_profiles.json)
- Rate-limited API (60 req/min standard, 10 req/min expensive)
- Read-only operations only
- CORS enabled with wildcard origins (no credentials)

### Testing
- 86 tests covering:
  - Edge cases (empty inputs, special characters)
  - API endpoints
  - Server functionality
  - Migrations
  - Version management

### Documentation
- Comprehensive README.md
- CLAUDE.md with Cyrus execution pattern
- Data attribution and legal notes
- MIT License with data disclaimer

### Infrastructure
- GitHub Actions:
  - Daily scrape at 6 AM UTC
  - Automated testing on all changes
  - Weekly releases with JSON/CSV exports
  - Manual trigger support
- Automated data commits
- Release tagging (data-N format)

## Development Notes

### Why Semantic Versioning?

- **Major (X.0.0)**: Breaking changes to API or data schema
- **Minor (0.X.0)**: New features, backward compatible
- **Patch (0.0.X)**: Bug fixes, documentation

### Update Frequency

- **Data**: Daily (automatic via GitHub Actions)
- **Code**: As needed for features/fixes
- **Releases**: Weekly (automation) + breaking changes (manual)

### Migration Policy

When breaking changes occur:
1. Update this changelog with version X.Y.Z
2. Update README with migration instructions
3. Ensure tests cover new behavior
4. Keep deprecated code for 1 major version cycle

### Issue Templates (Future)

Planned GitHub issue templates:
- Bug Report Template
- Feature Request Template
- Data Source Issue Template

[Unreleased]: https://github.com/romancircus/sota-tracker-mcp/compare/v1.0.0...HEAD
[1.0.0]: https://github.com/romancircus/sota-tracker-mcp/releases/tag/v1.0.0