const soroban = require('./index.js');
const { Address } = require('@stellar/stellar-sdk');

async function testInvoke() {
  console.log("Testing getContract...");
  // XLM Contract ID (Testnet)
  const XLM_CONTRACT = "CDLZFC3SYJYDZT7K67VZ75HPJVIEUVNIXF47ZG2FB2RMQQVU2HHGCYSC"; 
  
  const contractInfo = await soroban.getContract({ contractId: XLM_CONTRACT });
  console.log("Contract Info:", contractInfo);

  if (!contractInfo.exists) {
      console.log("Contract not found, skipping invoke test.");
      return;
  }

  console.log("\nTesting invokeRead (decimals)...");
  // Check decimals of the token
  const result = await soroban.invokeRead({
    contractId: XLM_CONTRACT,
    method: "decimals",
    args: []
  });
  
  console.log("Decimals Result:", result);

  console.log("\nTesting invokeRead (name)...");
   // Check name of the token
  const resultName = await soroban.invokeRead({
    contractId: XLM_CONTRACT,
    method: "name",
    args: []
  });
  console.log("Name Result:", resultName);
}

testInvoke();
