const { Address, xdr } = require('@stellar/stellar-sdk');

const contractId = "CAS3J7GYLGXMF6TDJBBYYSE3HQ6BBSMLNUQ34T6TZMYMW2EVH34XOWMA";
const contractAddress = new Address(contractId).toScAddress();

const ledgerKey = xdr.LedgerKey.contractData(
  new xdr.LedgerKeyContractData({
    contract: contractAddress,
    key: xdr.ScVal.scvLedgerKeyContractInstance(),
    durability: xdr.ContractDataDurability.persistent(),
  })
);

console.log("Type of ledgerKey:", typeof ledgerKey);
console.log("Has toXDR?", typeof ledgerKey.toXDR);
if (typeof ledgerKey.toXDR === 'function') {
    console.log("Base64:", ledgerKey.toXDR("base64"));
}
