const { Address, xdr, rpc } = require('@stellar/stellar-sdk');

async function test() {
    const contractId = "CDLZFC3SYJYDZT7K67VZ75HPJVIEUVNIXF47ZG2FB2RMQQVU2HHGCYSC";
    const server = new rpc.Server('https://soroban-testnet.stellar.org');

    const contractAddress = new Address(contractId).toScAddress();
    const ledgerKey = xdr.LedgerKey.contractData(
        new xdr.LedgerKeyContractData({
            contract: contractAddress,
            key: xdr.ScVal.scvLedgerKeyContractInstance(),
            durability: xdr.ContractDataDurability.persistent(),
        })
    );

    console.log("Calling getLedgerEntries with Spread Arguments...");
    try {
        const res = await server.getLedgerEntries(ledgerKey);
        console.log("Result Spread:", res);
    } catch (e) {
        console.log("Error Spread:", e.message);
    }
}

test();
