const { Asset, Networks, StrKey } = require('@stellar/stellar-sdk');

const network = Networks.TESTNET;
const nativeAsset = Asset.native();

try {
  const contractId = nativeAsset.contractId(network);
  console.log("Native Contract ID (Testnet):", contractId);
  console.log("Is Valid Contract:", StrKey.isValidContract(contractId));
} catch (e) {
  console.log("Error generating ID:", e.message);
}

// Try USDC Asset
const USDC_ISSUER = "GA5ZSEJYB37JRC5AVCIA5MOP4RHTM335X2KGX3IHOJAPP5RE34K4XZVN";
const usdcAsset = new Asset("USDC", USDC_ISSUER);
try {
  const usdcId = usdcAsset.contractId(network);
  console.log("USDC Contract ID:", usdcId);
  console.log("Is Valid Contract:", StrKey.isValidContract(usdcId));
} catch (e) {
  console.log("Error generating USDC ID:", e.message);
}
