# Song Structure Patterns

## Standard Forms

### Verse-Chorus (ABAB)
```
Intro → Verse 1 → Chorus → Verse 2 → Chorus → Outro
```
- Simple, direct
- Good for: Pop, rock, folk
- Risk: Can feel short or repetitive

### Verse-Chorus-Bridge (ABABCB)
```
Intro → V1 → Chorus → V2 → Chorus → Bridge → Final Chorus → Outro
```
- Most common pop structure
- Bridge provides contrast
- Final chorus often elevated (key change, bigger arrangement)

### AABA (32-bar form)
```
A (8 bars) → A (8 bars) → B (8 bars) → A (8 bars)
```
- Classic jazz/Tin Pan Alley
- Good for: Standards, torch songs
- B section = "bridge" or "release"

### Verse-Pre-Chorus-Chorus (APCABPCB)
```
V1 → Pre-Chorus → Chorus → V2 → Pre-Chorus → Chorus → Bridge → Chorus
```
- Modern pop standard
- Pre-chorus builds anticipation
- Creates bigger payoff at chorus

### Strophic (AAA)
```
Verse 1 → Verse 2 → Verse 3 → Verse 4...
```
- Same melody, different lyrics each time
- Good for: Story songs, folk ballads
- May have refrain line at end of each verse

---

## Section Functions

### Intro
- Sets mood and key
- 4-8 bars typical
- Can use chorus melody or unique riff
- Shouldn't give away the hook

### Verse
- Tells the story
- Lower energy than chorus
- 8-16 bars typical
- Should make listener want the chorus

### Pre-Chorus
- Builds tension
- Transitional energy
- 4-8 bars typical
- Often lifts melodically or harmonically
- Same pre-chorus each time (usually)

### Chorus
- Emotional payoff
- Contains the hook
- 8-16 bars typical
- Highest energy, most memorable
- Title usually appears here

### Bridge
- Contrast to everything before
- New harmonic territory
- 8 bars typical
- Often starts on IV or vi chord
- May have different perspective lyrically
- Sets up final chorus

### Outro
- Wraps the song
- 4-16 bars typical
- Options: fade out, cold ending, tag (repeat phrase), final statement

---

## Energy Maps

### Standard energy arc:
```
      Bridge  Final Chorus
         ↗         ↗↗
Chorus  ↗   Chorus  
   ↗          ↗
V1 ────── V2 ──────
```

### Ballad energy:
```
              Final Chorus
                  ↗↗
        Bridge  ↗
Chorus    ↗   Chorus
   ↗          ↗
V1 ────── V2 ──────
[slower build, more dynamics range]
```

### Dance/EDM energy:
```
         Drop          Drop 2
           ↗↗            ↗↗↗
Build ↗        Build 2 ↗
   ↗              ↗
Intro ──── Break ────
[tension → release cycles]
```

---

## Length Guidelines

| Section | Bars | At 120 BPM |
|---------|------|------------|
| Intro | 4-8 | 8-16 sec |
| Verse | 8-16 | 16-32 sec |
| Pre-chorus | 4-8 | 8-16 sec |
| Chorus | 8-16 | 16-32 sec |
| Bridge | 8 | 16 sec |
| Outro | 4-8 | 8-16 sec |

### Total song length targets:
- Radio edit: 3:00-3:30
- Album version: 3:30-4:30
- Extended/club: 5:00+
- Ballad: can go 4:00-5:00

---

## Arrangement Builds

### Making each chorus bigger:
1. **Chorus 1**: Core elements only
2. **Chorus 2**: Add harmony vocals, extra instrumentation
3. **Final Chorus**: Everything + key change or doubled chorus

### Section transitions:
- Drum fill before chorus
- Cymbal swell into drop
- Stop/pause before big moment
- Pre-chorus lift
- Bass drop out then return

---

## Unconventional Structures

### Starting with chorus:
```
Chorus → Verse 1 → Chorus → Verse 2 → Chorus → Bridge → Chorus
```
- Hooks listener immediately
- Works when chorus is extremely strong

### No chorus:
```
Verse 1 → Verse 2 → Verse 3 → Verse 4
```
- Story-driven
- Each verse must be compelling

### Double bridge:
```
V1 → C → V2 → C → Bridge 1 → Bridge 2 → Final C
```
- More dramatic build
- Common in epic rock songs

### Post-chorus:
```
V1 → C → Post-C → V2 → C → Post-C → Bridge → C → Post-C
```
- Extra hook after chorus
- Common in modern pop (Taylor Swift, etc.)
