# Lyric Writing Techniques

## Rhyme Schemes

| Scheme | Pattern | Effect | Example |
|--------|---------|--------|---------|
| AABB | Couplets | Driving, punchy | "I walk the line / I keep my eyes wide open all the time" |
| ABAB | Alternating | Classic, balanced | Most pop songs |
| ABCB | Second/fourth | Conversational, loose | Folk, storytelling |
| XAXA | Only even lines | Modern, natural | Hip-hop, spoken word |

## Rhyme Types

| Type | Description | Example |
|------|-------------|---------|
| **Perfect** | Identical ending sounds | time/rhyme |
| **Near/Slant** | Close but not exact | time/mine, love/enough |
| **Assonance** | Same vowel sounds | time/light, road/home |
| **Consonance** | Same consonant sounds | time/team, black/clock |

**Tip:** Looser rhymes in verses, tighter in choruses.

---

## Syllable Patterns

### Common meters (stressed syllables in CAPS):
- **Iambic**: da-DUM da-DUM ("a-WAKE and SEE the SUN")
- **Trochaic**: DUM-da DUM-da ("WALK-ing THROUGH the RAIN")
- **Anapestic**: da-da-DUM ("in the DARK of the NIGHT")

### Matching music:
- Stressed syllables should land on downbeats
- Important words on strong beats
- Unstressed syllables on upbeats

---

## Emotional Techniques

### Show, don't tell:
- ❌ "I'm sad"
- ✅ "The coffee's cold, I haven't moved in hours"

### Concrete imagery:
- ❌ "We had good times"
- ✅ "The backseat of your car, summer of '99"

### Sensory details:
- What do they see, hear, smell, feel, taste?
- Grounds abstract emotions in reality

### Metaphor and simile:
- Extended metaphors (carry through the song)
- Fresh comparisons (avoid "heart on fire" unless subverting)

---

## Structure Within Sections

### Verse pattern:
```
Line 1: Setup (who, where, when)
Line 2: Action or observation
Line 3: Emotional response
Line 4: Lead into chorus
```

### Chorus pattern:
```
Line 1: The hook (title or main phrase)
Line 2: Expansion of the hook
Line 3: Contrast or consequence
Line 4: Return to hook (often repeated)
```

### Bridge pattern:
```
Line 1: Shift perspective ("But then I realized...")
Line 2: New information or confession
Line 3: Emotional pivot
Line 4: Setup for final chorus
```

---

## Common Pitfalls

| Problem | Solution |
|---------|----------|
| Too abstract | Add one concrete image per verse |
| Forced rhymes | Use near-rhymes or restructure |
| Clichés | Twist the expected phrase |
| Too wordy | Cut to essential words |
| Unclear story | Ensure each verse advances narrative |
| Monotonous rhythm | Vary syllable counts between sections |

---

## Writer's Block Techniques

1. **Object writing**: Pick random object, write freely for 10 min
2. **Title first**: Write hook/title, work backward
3. **Conversation**: Write as if talking to someone
4. **Constraint**: Write without using certain common words (love, heart, time)
5. **Persona**: Write from another person's viewpoint
6. **Cut-up**: Rearrange existing lyrics into new combinations
