# Chord Progressions by Mood

## Quick Reference

| Mood | Key | Progression | Songs that use it |
|------|-----|-------------|-------------------|
| Happy/uplifting | Major | I - IV - V - I | Classic rock, pop |
| Anthemic | Major | I - V - vi - IV | "Let It Be," "No Woman No Cry" |
| Melancholic | Minor | i - VI - III - VII | "Mad World," many modern pop |
| Nostalgic | Major | I - V - vi - iii - IV | "Canon" progression |
| Bittersweet | Major/minor | I - vi - IV - V | 50s progression, "Stand By Me" |
| Dreamy | Major | Imaj7 - IVmaj7 - vi7 - V | Neo-soul, chill |
| Dark/intense | Minor | i - iv - v - i | Heavy rock, dramatic |
| Hopeful | Major | vi - IV - I - V | "Someone Like You," empowerment songs |

---

## By Genre

### Pop
- I - V - vi - IV (the "pop-punk" progression)
- vi - IV - I - V (starts minor, resolves major)
- I - IV - vi - V (similar energy, different order)
- I - V - IV - V (driving verse progression)

### Rock
- I - IV - V (classic rock)
- I - bVII - IV (rock shuffle feel)
- i - bVII - bVI - bVII (hard rock power)
- I - bIII - IV (alt-rock color)

### Folk/Acoustic
- I - IV - I - V (simple, open)
- I - vi - IV - V (gentle movement)
- I - IV - V - IV (circular, campfire)
- I - V - IV (three-chord wonder)

### Electronic/Dance
- i - VI - III - VII (minor but driving)
- I - I - IV - IV (two-chord hypnosis)
- vi - V - IV - V (building energy)
- Modal: same chord with bass movement

### Hip-Hop/R&B
- i - iv - VII - III (modern trap)
- I - vi - ii - V (jazz-influenced)
- i - bVI - bVII - i (dark bounce)
- ii - V - I (jazzy resolution)

### Country
- I - IV - V - I (classic)
- I - V - IV - I (truck-song progression)
- I - vi - IV - V (emotional ballad)
- ii - V - I (Nashville influence)

---

## Emotion → Chords

### To create tension:
- Add 7ths (V7 → I resolution)
- Use diminished (viidim leading to I)
- Chromatic movement (E → F → F#)
- Suspended chords (Csus4 → C)

### To create release:
- Resolve to I (home chord)
- Major after minor (i → IV → I)
- Descending bass lines
- Remove dissonance

### To create mystery:
- Ambiguous chords (add2, sus, no3)
- Avoid clear tonic
- Modal interchange
- Pedal tones

### To create energy:
- Shorter chord durations
- Rising bass lines
- Secondary dominants
- Anticipate chord changes

---

## Section Dynamics

### Verse progressions (lower energy):
- Fewer chords, more repetition
- Can start on non-tonic (vi, ii)
- More space, less dense

### Chorus progressions (higher energy):
- Clear tonic center
- Stronger root movement (fourths, fifths)
- More predictable resolution

### Bridge progressions (contrast):
- Start on unexpected chord (IV, ii, vi)
- May visit relative major/minor
- Build back to chorus

---

## Practical Tips

1. **Try the progression before committing**: Play through, sing melody over it
2. **Match energy to section**: Don't use most powerful progression in verse
3. **Consider bass movement**: Smooth bass lines feel cohesive
4. **Inversions add interest**: C/E instead of C changes the feel
5. **Silence is a chord**: Rests create drama
