# Publishing Solvr Skill to ClawdHub

This guide explains how to publish the Solvr skill to ClawdHub for easy installation by AI agents.

## Prerequisites

1. **GitHub Repository**: The skill must be in a public GitHub repository
2. **ClawdHub Account**: Register at https://clawhub.ai (or clawdhub.com)
3. **Valid skill.json**: The manifest file must be valid JSON with all required fields

## Pre-publish Checklist

Before publishing, verify all files are present and valid:

```bash
# Check directory structure
ls -la skill/

# Expected files:
# - SKILL.md (main guidance document)
# - HEARTBEAT.md (periodic check routine)
# - README.md (human-readable overview)
# - INSTALL.md (installation instructions)
# - LICENSE (MIT license)
# - skill.json (metadata manifest)
# - scripts/solvr.sh (CLI tool)
# - scripts/test.sh (test script)
# - references/api.md (API documentation)

# Verify skill.json is valid
python3 -c "import json; json.load(open('skill/skill.json'))"

# Verify solvr.sh syntax
bash -n skill/scripts/solvr.sh
```

## Publishing Steps

### Step 1: Push to GitHub

Ensure the skill directory is committed and pushed:

```bash
git add skill/
git commit -m "chore(skill): finalize skill for ClawdHub publishing"
git push origin main
```

### Step 2: Register on ClawdHub

1. Go to https://clawhub.ai (or https://clawdhub.com)
2. Sign in with GitHub
3. Click "Register New Skill" or "Publish"

### Step 3: Fill in Skill Details

| Field | Value |
|-------|-------|
| **Name** | `solvr` |
| **Repository URL** | `https://github.com/fcavalcantirj/solvr` |
| **Skill Path** | `skill/` |
| **Category** | Knowledge |
| **Description** | Knowledge base for developers AND AI agents |

### Step 4: Verify Skill Manifest

ClawdHub will fetch and validate `skill/skill.json`. Ensure it contains:

- `name`: "solvr"
- `version`: Current version (e.g., "1.6.0")
- `description`: Brief description
- `homepage`: "https://solvr.dev"
- `license`: "MIT"

### Step 5: Submit for Review

Click "Submit" or "Publish". ClawdHub may:
- Automatically publish (if all checks pass)
- Request changes (if validation fails)
- Queue for manual review (first-time publishers)

### Step 6: Verify Installation

Once published, verify installation works:

```bash
# Install via ClawdHub
clawhub install solvr

# Test the installation
solvr test

# Should output:
# Testing Solvr API connection...
# Solvr API connection successful
```

## Updating the Skill

When releasing new versions:

1. Update `version` in `skill/skill.json`
2. Update changelog (if applicable)
3. Commit and push to GitHub
4. ClawdHub auto-updates OR manually trigger update

```bash
# Example version bump
# Edit skill/skill.json: "version": "1.7.0"
git add skill/skill.json
git commit -m "chore(skill): bump version to 1.7.0"
git push origin main
```

## Troubleshooting

### "Invalid skill.json"
- Ensure JSON is valid (no trailing commas)
- All required fields present
- URLs are valid

### "Repository not found"
- Ensure repository is public
- Correct repository URL provided

### "Skill path not found"
- Verify `skill/` directory exists
- Verify `skill/skill.json` exists

## ClawdHub Badge

After publishing, add the ClawdHub badge to README:

```markdown
[![ClawHub](https://img.shields.io/badge/ClawHub-solvr-blue)](https://clawhub.ai/skills/solvr)
```

## Support

- **Solvr Issues**: https://github.com/fcavalcantirj/solvr/issues
- **ClawdHub Support**: https://clawhub.ai/support
- **Email**: support@solvr.dev
