# STREAM 6-Layer Framework (for Validation)

Extracted from `0-principles/stream-framework.md`. Use for scoring ideas.

> **STREAM** = **S**cope (epistemological) · **T**ime (temporal) · **R**oute (action) · **E**xposure (stakes) · **A**udience (social) · **M**eaning (meta)

## Layer 1: Epistemological (Scope)

| Principle | Question |
|-----------|----------|
| **Map != Territory** | What am I assuming without evidence? List 3 unproven assumptions. |
| **Simplicity** | Is this solution simple or am I building complexity-debt? |
| **Honesty** | Am I being honest about the opportunity or optimistic? |
| **Boundaries** | Is this within my circle of competence? |

## Layer 2: Temporal (Time)

| Principle | Question |
|-----------|----------|
| **Time** | What's the REAL time investment? (hours of my life) |
| **Entropy** | Will this product exist in 5 years? What decays? |
| **Flow** | Is the timing right, or am I chasing hype? |
| **Lindy** | Is this Lindy-compliant (proven by time)? |

## Layer 3: Action (Route)

| Principle | Question |
|-----------|----------|
| **Inversion** | How would I GUARANTEE failure? (then don't do those things) |
| **Second-Order Effects** | What are second-order effects? Effects of effects? |
| **Feedback** | How will I measure success? What's the feedback loop? |
| **Action** | What's the minimum viable action? |

## Layer 4: Stakes (Exposure)

| Principle | Question |
|-----------|----------|
| **Asymmetry** | What's the REAL risk/reward? Use pessimistic numbers. |
| **Antifragility** | Does building this make me MORE or LESS antifragile? |
| **Stay in the Game** | Can I keep playing if this fails? (survivable downside?) |
| **Focus** | Is this focused enough, or am I diversifying out of fear? |

## Layer 5: Social (Audience)

| Principle | Question |
|-----------|----------|
| **Reputation** | Building this — deposit or withdrawal from reputation? |
| **Network** | Does this connect me to better people? |
| **Masks** | What happens if this publicly fails? |

## Layer 6: Meta (Meaning)

| Principle | Question |
|-----------|----------|
| **Mortality** | Would I regret NOT building this? (Memento mori filter) |
| **Balance** | Is this the best use of my finite time right now? |
| **Paradox** | Does this align with "tools that help people reflect, create, and own their narrative"? |

## Scoring Rules

- Each layer scored 1-10
- **Layer 4 (Stakes)** and **Layer 6 (Meta)** weighted 1.5x
- If Devil's Advocate found critical issues → reduce affected layer scores
- If Manifest has violations → reduce Layer 6 (Meta) score
- Final score = weighted average
