---
name: solo-landing-gen
description: Generate landing page content from PRD — hero section, features, A/B headline variants, CTA, and SEO meta tags. Use when user says "create landing page", "write landing copy", "hero section", "A/B headlines", or "landing content". Can scaffold actual pages for astro-static. Do NOT use for SEO auditing (use /seo-audit).
license: MIT
metadata:
  author: fortunto2
  version: "1.1.1"
  openclaw:
    emoji: "🛬"
allowed-tools: Read, Grep, Glob, Write, Edit, Bash, AskUserQuestion, mcp__solograph__kb_search, mcp__solograph__project_info, mcp__solograph__web_search
argument-hint: "<project-name>"
---

# /landing-gen

Generate landing page content from a project's PRD. Produces hero section, features, social proof, CTA, SEO meta tags, and A/B headline variants. If astro-static stack detected, can scaffold actual page files.

## MCP Tools (use if available)

- `kb_search(query)` — find related methodology (conversion, copywriting)
- `project_info(name)` — get project stack and details
- `web_search(query)` — competitor landing analysis

If MCP tools are not available, fall back to Glob + Grep + Read.

## Steps

1. **Parse project** from `$ARGUMENTS`.
   - Read PRD, README, or research.md for product info.
   - If empty: ask via AskUserQuestion.

2. **Detect stack:**
   - Check for `astro.config.*` → astro-static (can scaffold page)
   - Check for `next.config.*` → Next.js (can scaffold route)
   - Otherwise: generate content-only markdown

3. **Extract landing inputs** from PRD/README:
   - **Problem:** 1 sentence pain statement
   - **Solution:** 1 sentence product description
   - **ICP:** Target user persona
   - **Features:** Top 3-4 differentiating features with descriptions
   - **Competitors:** From research.md (if exists) — for positioning
   - **Pricing:** If available

4. **Competitor landing analysis** (optional, if MCP/WebSearch available):
   - Search for top 3 competitor landing pages
   - Note: headline patterns, CTA language, social proof types
   - Identify positioning gaps

5. **Forced reasoning — conversion strategy:**
   Before generating, write out:
   - **Primary conversion:** What's the ONE action? (sign up / download / buy)
   - **Objections:** Top 3 reasons someone wouldn't convert
   - **Trust signals:** What overcomes each objection?
   - **Above the fold:** Problem + Solution + CTA — nothing else

6. **Generate landing content:**

   ### 6a. Hero Section
   - **Headline:** Problem-focused, benefit-driven (8-12 words)
   - **Subheadline:** How the product solves it (15-25 words)
   - **CTA button:** Action verb + outcome ("Start Free Trial", "Download Now")
   - **Visual:** Describe what image/screenshot/demo should be shown

   ### 6b. A/B Headline Variants (5 options)
   Generate 5 distinct headline approaches:
   1. Pain-focused: "Tired of {problem}?"
   2. Benefit-focused: "{Outcome} without {hassle}"
   3. Curiosity: "The {adjective} way to {action}"
   4. Social proof: "Join {N}+ {users} who {outcome}"
   5. Direct: "{Product}: {one-line value prop}"

   ### 6c. Features Section (3-4 features)
   For each feature:
   - Icon suggestion (emoji or icon name)
   - Feature title (3-5 words)
   - Feature description (1-2 sentences)
   - Benefit framing (what user gains, not what product does)

   ### 6d. Social Proof Section
   - Placeholder for testimonials (template with name, role, quote)
   - Metrics placeholders ("X+ users", "Y% faster", "Z countries")
   - Trust badges placeholder (App Store rating, awards, press)

   ### 6e. CTA Section
   - Repeat headline (or variation)
   - CTA button (same as hero)
   - Risk reducer ("Free forever" / "No credit card" / "Cancel anytime")

   ### 6f. SEO Meta Tags
   ```html
   <title>{title — 50-60 chars}</title>
   <meta name="description" content="{description — 150-160 chars}">
   <meta property="og:title" content="{og title}">
   <meta property="og:description" content="{og description}">
   <meta property="og:image" content="{suggest image dimensions 1200x630}">
   <meta property="og:type" content="website">
   ```

7. **Write output:**

   **If astro-static detected:** scaffold page at `src/pages/index.astro` or new route.

   **Otherwise:** write to `docs/landing-content.md`:

   ```markdown
   # Landing Page Content: {Project Name}

   **Generated:** {YYYY-MM-DD}
   **Primary CTA:** {action}
   **Target ICP:** {persona}

   ## Hero
   **Headline:** {headline}
   **Subheadline:** {subheadline}
   **CTA:** {button text}
   **Visual:** {description}

   ## A/B Headlines
   1. {variant 1}
   2. {variant 2}
   3. {variant 3}
   4. {variant 4}
   5. {variant 5}

   ## Features
   {features with icons and descriptions}

   ## Social Proof
   {templates and placeholders}

   ## Final CTA
   {closing section}

   ## SEO Meta Tags
   {html meta tags}

   ---
   *Generated by /landing-gen. Fill in social proof, add visuals, then publish.*
   ```

8. **Output summary** — headline, CTA, and suggested next steps.

## Notes

- Headline should be testable — run A/B with 2-3 variants
- "Above the fold" = hero only — don't overload
- Social proof is placeholder — fill with real data as it comes
- For fake-door tests: hero + CTA + email capture is enough (2-hour launch)
- Works with /seo-audit — generate content, then audit the deployed page

## Common Issues

### No PRD or product info found
**Cause:** Project lacks `docs/prd.md` or README with product description.
**Fix:** Run `/validate` to generate PRD first, or provide a README with problem/solution/features.

### Headlines too generic
**Cause:** Weak problem statement or missing competitor differentiation.
**Fix:** Add `research.md` with competitive analysis. Specific pain points produce specific headlines.

### Stack not detected for page scaffolding
**Cause:** No `astro.config.*` or `next.config.*` found.
**Fix:** Skill outputs content-only markdown by default. To get actual page files, ensure the project uses astro-static or nextjs-supabase stack.
