---
name: solo-content-gen
description: Generate social media content pack from PRD — LinkedIn post, Reddit answer draft, and Twitter/X thread. Use when user says "create content", "write LinkedIn post", "social media pack", "marketing copy", or "promotion content". Do NOT use for community thread responses (use /community-outreach) or video scripts (use /video-promo).
license: MIT
metadata:
  author: fortunto2
  version: "1.1.1"
  openclaw:
    emoji: "📝"
allowed-tools: Read, Grep, Glob, Write, AskUserQuestion, mcp__solograph__kb_search, mcp__solograph__project_info, mcp__solograph__project_code_search
argument-hint: "<project-name or path>"
---

# /content-gen

Generate a promotion content pack from a project's PRD or README. Produces 3 ready-to-use content pieces: LinkedIn post, Reddit answer draft, and Twitter/X thread. For video scripts, use `/video-promo`.

## MCP Tools (use if available)

- `kb_search(query)` — find related methodology and principles
- `project_info(name)` — get project details, stack, description
- `project_code_search(query, project)` — find key features in codebase

If MCP tools are not available, fall back to Glob + Grep + Read.

## Steps

1. **Parse project** from `$ARGUMENTS`.
   - If project name: find PRD at `docs/prd.md`, or README.md, or CLAUDE.md.
   - If path: read directly.
   - If empty: ask via AskUserQuestion — "Which project to generate content for?"

2. **Extract core messaging** from PRD/README (parallel reads):
   - **Problem:** What pain does this solve? (1 sentence)
   - **Solution:** What does the product do? (1 sentence)
   - **ICP:** Who is the target user? (persona)
   - **Key features:** Top 3-5 differentiating features
   - **Unique angle:** What nobody else does (gap from research.md if exists)
   - **Social proof:** Any metrics, users, downloads (if available)

3. **Forced reasoning — messaging framework:**
   Before generating content, write out:
   - **Hook:** What stops the scroll? (pain point or surprising stat)
   - **Proof:** Why should they believe you? (demo, numbers, authority)
   - **CTA:** What's the one action? (try, sign up, download)
   - **Tone:** Based on ICP — casual/professional/technical/friendly

4. **Generate content pieces:**

   ### 4a. LinkedIn Post
   Format: Hook line → Story (before/after) → Insight → CTA
   - 1300-1500 chars max
   - First line is the hook (visible before "see more")
   - Use line breaks for readability
   - End with question to drive engagement

   ### 4b. Reddit Answer Draft
   Format: Helpful answer that naturally mentions the product
   - NOT promotional — value-first, product mention is secondary
   - Suggest 3-5 subreddits where this would be relevant
   - Write as if answering someone's genuine question
   - Include "disclaimer: I built this" transparency

   ### 4c. Twitter/X Thread (5-7 tweets)
   Format: Hook tweet → Problem → Solution → Demo → Social proof → CTA
   - Each tweet: 240-280 chars max
   - Tweet 1: standalone hook (works without thread)
   - Last tweet: CTA with link
   - Include emoji sparingly (1-2 per tweet max)

5. **Write content pack** to `docs/content-pack.md`:

   ```markdown
   # Content Pack: {Project Name}

   **Generated:** {YYYY-MM-DD}
   **ICP:** {target persona}
   **Core message:** {one-line value prop}

   ## Messaging Framework
   - **Hook:** {hook}
   - **Proof:** {proof}
   - **CTA:** {cta}

   ---

   ## 1. LinkedIn Post
   {ready to copy-paste}

   ## 2. Reddit Draft
   **Target subreddits:** r/..., r/..., r/...
   {answer draft}

   ## 3. Twitter/X Thread
   {numbered tweets}

   > For video script, run `/video-promo {project}`.

   ---
   *Generated by /content-gen. Edit before publishing.*
   ```

6. **Output summary** — print core message + list of generated content pieces.

## Notes

- All content is draft — always review before publishing
- Reddit draft should feel genuinely helpful, not promotional
- For video scripts, use `/video-promo` (owns video generation entirely)
- Rerun after major product updates to refresh messaging
- Works best with detailed PRD — falls back to README if no PRD

## Common Issues

### No PRD found
**Cause:** Project doesn't have `docs/prd.md` or README.
**Fix:** Provide a project path with PRD, or run `/validate` first to generate one.

### Content too generic
**Cause:** PRD lacks specific differentiators or ICP details.
**Fix:** Ensure PRD has detailed problem statement, ICP persona, and unique angle. Add `research.md` for competitive context.

### Wrong tone for audience
**Cause:** ICP not clearly defined in PRD.
**Fix:** Specify the target audience in PRD. LinkedIn = professional, Reddit = casual/technical, Twitter = punchy/conversational.
