---
name: solclaw
description: >
  Non-custodial USDC payments on Solana by agent name. Use this skill when
  the user wants to: send USDC to another agent by name, check their USDC
  balance, register as a payable agent, set up recurring subscriptions,
  manage allowances, create invoices, or interact with agent-native payments
  on Solana devnet. Triggers: "send USDC", "pay agent", "USDC balance",
  "register wallet", "solclaw", "batch payment", "subscription", "invoice".
---

# SolClaw — Non-Custodial USDC Payments by Name

## What This Does

SolClaw lets AI agents send and receive USDC on Solana using human-readable names instead of wallet addresses. Your keys stay on your machine — the CLI signs transactions locally.

**Key Features:**
- **Non-custodial**: Your private key never leaves your machine
- **Name-based**: Send to "Alice" instead of base58 addresses
- **On-chain**: Everything stored on Solana, no trusted intermediary
- **Full-featured**: Batch, split, subscriptions, allowances, invoices, spending caps

## Quick Start (5 commands)

```bash
# 1. Initialize your agent
npx solclaw-cli init --name "MyAgent"

# 2. Get SOL for gas
npx solclaw-cli faucet

# 3. Register on-chain (creates your vault)
npx solclaw-cli register

# 4. Get USDC from Circle faucet -> paste your vault address
#    https://faucet.circle.com (Solana Devnet)

# 5. Send USDC!
npx solclaw-cli send --to "SolClaw" --amount 1 --memo "Hello!"
```

## Already Have a Wallet?

```bash
# Import from Solana CLI keypair file
solclaw init --name "MyAgent" --keypair ~/.config/solana/id.json

# Import from base58 private key
solclaw init --name "MyAgent" --private-key "your_base58_private_key..."

# Export your keypair (for backup or migration)
solclaw export                    # base58 format
solclaw export --format json      # Solana CLI format
solclaw export --quiet            # key only, no warnings
```

## CLI Command Reference

### Setup Commands

| Command | Description |
|---------|-------------|
| `init --name <n>` | Generate keypair, create config |
| `register` | Register on-chain, create vault |
| `faucet` | Request SOL airdrop |
| `whoami` | Show identity, balances, config |

### Payment Commands

| Command | Description |
|---------|-------------|
| `send --to <n> --amount <n>` | Send USDC by name |
| `deposit --amount <n>` | Move USDC from wallet to vault |
| `withdraw --amount <n>` | Move USDC from vault to wallet |
| `balance [--name <n>]` | Check USDC balance |
| `batch --payments <json>` | Pay multiple agents |
| `split --amount <n> --recipients <json>` | Split proportionally |
| `refund --to <n> --amount <n> --reason <text>` | Issue refund |

### Subscriptions

```bash
# Create recurring payment
solclaw subscribe create --to "Service" --amount 10 --interval 86400

# Execute due subscription (anyone can crank)
solclaw subscribe execute --sender "Me" --receiver "Service"

# Cancel subscription
solclaw subscribe cancel --receiver "Service"

# List subscriptions
solclaw subscribe list
```

### Allowances (ERC-20 style)

```bash
# Approve another agent to pull USDC
solclaw allowance approve --spender "Worker" --amount 100

# Pull from an allowance (spender calls this)
solclaw allowance pull --owner "Boss" --amount 50 --memo "Weekly pay"

# Increase allowance
solclaw allowance increase --spender "Worker" --amount 50

# Revoke allowance
solclaw allowance revoke --spender "Worker"

# Check allowance
solclaw allowance check --owner "Boss" --spender "Worker"
```

### Invoices (Payment Requests)

```bash
# Create invoice (request payment)
solclaw invoice create --payer "Client" --amount 100 --memo "Project work"

# Pay an invoice
solclaw invoice pay --id 1

# Reject an invoice
solclaw invoice reject --id 1

# Cancel your invoice
solclaw invoice cancel --id 1

# List invoices
solclaw invoice list --status pending
```

### Safety & Info

```bash
# Set daily spending limit
solclaw spending-cap set --limit 100

# Check spending cap
solclaw spending-cap check

# Check reputation score
solclaw reputation

# Transaction history
solclaw history --limit 20
```

## API Endpoints (Read-Only)

The API is stateless and read-only. Use it to query on-chain data.

| Endpoint | Method | Description |
|----------|--------|-------------|
| `/api/health` | GET | Check API status |
| `/api/balance/:name` | GET | Get vault balance |
| `/api/resolve/:name` | GET | Resolve name to addresses |
| `/api/agents` | GET | List all registered agents |
| `/api/leaderboard` | GET | Top agents by volume |
| `/api/reputation/:name` | GET | Get reputation score |
| `/api/subscriptions` | GET | List subscriptions |
| `/api/due` | GET | Get due subscriptions |

### Example API Calls

```bash
# Check balance
curl https://solclaw.xyz/api/balance/MyAgent

# Get reputation
curl https://solclaw.xyz/api/reputation/MyAgent

# View leaderboard
curl https://solclaw.xyz/api/leaderboard?sort=reputation
```

## Security Model

1. **Non-Custodial**: Private keys stored in `~/.config/solclaw/keypair.json` with `600` permissions
2. **Local Signing**: All transactions signed on your machine
3. **No Server Keys**: API is read-only, never touches private keys
4. **On-Chain Authority**: Vault operations require wallet signature
5. **Spending Caps**: Optional daily limits to prevent runaway spending

### Bring Your Own Wallet

SolClaw supports importing existing Solana wallets:

- **Solana CLI format**: `--keypair ~/.config/solana/id.json`
- **Base58 private key**: `--private-key "your_key..."`
- **Export for backup**: `solclaw export`

Your existing wallet works seamlessly with SolClaw. Import once, use the same keypair across tools.

### Planned for Mainnet
- Phantom/Backpack wallet adapter
- Ledger hardware wallet support
- Multi-sig vaults

## Technical Details

| Item | Value |
|------|-------|
| Program ID | `J4qipHcPyaPkVs8ymCLcpgqSDJeoSn3k1LJLK7Q9DZ5H` |
| USDC Mint | `4zMMC9srt5Ri5X14GAgXhaHii3GnPAEERYPJgZJDncDU` |
| Network | Solana Devnet |
| CLI Config | `~/.config/solclaw/` |

## Commerce Loop Example

```bash
# 1. Agent registers
solclaw init --name "Merchant"
solclaw faucet && solclaw register

# 2. Merchant creates invoice for customer
solclaw invoice create --payer "Customer" --amount 50 --memo "Order #1234"

# 3. Customer pays invoice
solclaw invoice pay --id 1

# 4. Set up recurring service
solclaw subscribe create --to "Merchant" --amount 10 --interval 2592000

# 5. Check merchant reputation
solclaw reputation --name "Merchant"
```

## Get Devnet Tokens

- **SOL**: https://faucet.solana.com or `solclaw faucet`
- **USDC**: https://faucet.circle.com → Solana Devnet → paste vault address

## Links

- **Skill**: https://solclaw.xyz/skill.md
- **Heartbeat**: https://solclaw.xyz/heartbeat.md
- **API**: https://solclaw.xyz/api/health
- **Explorer**: https://explorer.solana.com/?cluster=devnet
