---
name: solana-sniper-bot
description: Autonomous Solana token sniper and trading bot. Monitors new token launches on Raydium/Jupiter, evaluates rugpull risk with LLM analysis, auto-buys promising launches, and manages exit strategies. Use when user wants to snipe Solana token launches, trade memecoins, monitor new Solana pairs, or build a Solana trading bot. Supports cron-based monitoring, take-profit/stop-loss, and portfolio tracking.
metadata: {"openclaw": {"requires": {"env": ["SOLANA_PRIVATE_KEY", "LLM_API_KEY"]}, "primaryEnv": "LLM_API_KEY", "homepage": "https://github.com/srikanthbellary"}}
---

# Solana Sniper Bot

Autonomous token sniper for Solana. Monitors Raydium and Jupiter for new liquidity pools, evaluates tokens using LLM-powered rugpull detection, and executes buy/sell orders via Jupiter aggregator.

## Prerequisites

- **Solana wallet** with SOL for gas + trading capital (USDC or SOL)
- **Anthropic API key** (uses Haiku for token evaluation ~$0.001/eval)
- **Helius or QuickNode RPC** (free tier works, paid recommended for speed)

## Setup

### 1. Install Dependencies

```bash
python3 {baseDir}/scripts/setup.sh
```

Or manually:
```bash
pip install solana solders httpx aiohttp python-dotenv
```

### 2. Configuration

Create `.env`:
```
SOLANA_PRIVATE_KEY=<base58-private-key>
LLM_API_KEY=<anthropic-api-key>
RPC_URL=https://api.mainnet-beta.solana.com
HELIUS_API_KEY=<optional-for-faster-monitoring>
BUY_AMOUNT_SOL=0.1
TAKE_PROFIT=2.0
STOP_LOSS=0.5
```

### 3. Deploy

```bash
cp {baseDir}/scripts/sniper.py /opt/sniper/
python3 /opt/sniper/sniper.py
```

## How It Works

1. **Pool Monitor** — Watches Raydium AMM for new liquidity pool creation events
2. **Token Analysis** — For each new pool, queries token metadata:
   - Mint authority (revoked = good)
   - Freeze authority (revoked = good)
   - LP burned/locked percentage
   - Top holder concentration
   - Contract verification status
3. **LLM Risk Assessment** — Sends token data to Claude Haiku for rugpull probability estimate
4. **Auto-Buy** — If risk score < threshold, buys via Jupiter aggregator for best price
5. **Position Management** — Monitors positions with take-profit and stop-loss triggers
6. **Auto-Sell** — Exits via Jupiter when TP/SL hit

## Risk Scoring

Each token gets scored 0-100 (lower = safer):

| Factor | Weight | Red Flag |
|--------|--------|----------|
| Mint authority | 25% | Not revoked |
| Freeze authority | 20% | Not revoked |
| LP lock | 20% | < 80% locked |
| Top 10 holders | 15% | > 50% supply |
| Contract age | 10% | < 1 hour |
| LLM sentiment | 10% | Negative assessment |

Default buy threshold: risk score < 40

## Trading Parameters

Configurable in `.env`:
- `BUY_AMOUNT_SOL` — Amount per snipe (default: 0.1 SOL)
- `TAKE_PROFIT` — Exit multiplier (default: 2.0 = 100% gain)
- `STOP_LOSS` — Exit multiplier (default: 0.5 = 50% loss)
- `MAX_POSITIONS` — Max concurrent positions (default: 5)
- `MIN_LIQUIDITY` — Minimum pool liquidity in USD (default: $5000)
- `SLIPPAGE_BPS` — Slippage tolerance in bps (default: 500 = 5%)

## ⚠️ Security Considerations

- **Use a DEDICATED wallet** with only what you're willing to lose
- **Memecoin trading is extremely high risk** — most new tokens go to zero
- **Never use your main wallet's private key**
- Start with tiny amounts (0.01-0.1 SOL per trade)
- Monitor actively — this is not a set-and-forget system
- **RPC rate limits** — Free Solana RPC will miss fast launches. Use Helius/QuickNode for serious sniping.

## References

- See `references/jupiter-api.md` for Jupiter aggregator API docs
- See `references/raydium-pools.md` for pool monitoring details
