# Curated Resources (Source-of-Truth First)

**Source**: https://solana.com/resources.md

## Learning Platforms
- [Blueshift](https://learn.blueshift.gg/) - Free, open-source Solana learning
- [Solana Cookbook](https://solanacookbook.com/)

## Core Solana Docs
- [Solana Documentation](https://solana.com/docs)
- [Next.js + Solana React Hooks](https://solana.com/docs/frontend/nextjs-solana)
- [RPC API Reference](https://solana.com/docs/rpc)

## Modern JS/TS SDK
- [@solana/kit Repository](https://github.com/anza-xyz/kit)
- [Solana Kit Docs](https://solana.com/docs/clients/kit)

## UI and Wallet
- [framework-kit Repository](https://github.com/solana-foundation/framework-kit)
- [ConnectorKit](https://github.com/civic-io/connector-kit)

## Scaffolding
- [create-solana-dapp](https://github.com/solana-developers/create-solana-dapp)

## Program Frameworks
### Anchor
- [Anchor Repository](https://github.com/coral-xyz/anchor)
- [Anchor Documentation](https://www.anchor-lang.com/)

### Pinocchio
- [Pinocchio Repository](https://github.com/anza-xyz/pinocchio)
- [How to Build with Pinocchio (Helius)](https://www.helius.dev/blog/pinocchio)

## Testing
- [LiteSVM](https://github.com/LiteSVM/litesvm)
- [Mollusk](https://github.com/buffalojoec/mollusk)
- [Surfpool](https://docs.surfpool.dev/)

## IDLs and Codegen
- [Codama](https://github.com/codama-idl/codama)

## Tokens and NFTs
- [SPL Token Documentation](https://spl.solana.com/token)
- [Token-2022 Documentation](https://spl.solana.com/token-2022)
- [Metaplex Documentation](https://developers.metaplex.com/)

## Payments
- [Commerce Kit](https://commercekit.solana.com/)

## Security
- [Blueshift Program Security Course](https://learn.blueshift.gg/en/courses/program-security)
- [Solana Security Best Practices](https://solana.com/docs/programs/security)

Full list: https://solana.com/resources.md
