# Solana Development Skill (framework-kit-first)

**Source**: https://solana.com/SKILL.md  
**Date**: Jan 2026  
**Official Solana Foundation skill for AI agents**

## What this Skill is for
Use this Skill when the user asks for:
- Solana dApp UI work (React / Next.js)
- Wallet connection + signing flows
- Transaction building / sending / confirmation UX
- On-chain program development (Anchor or Pinocchio)
- Client SDK generation (typed program clients)
- Local testing (LiteSVM, Mollusk, Surfpool)
- Security hardening and audit-style reviews

## Default stack decisions (opinionated)

### 1) UI: framework-kit first
- Use `@solana/client` + `@solana/react-hooks`
- Prefer Wallet Standard discovery/connect via the framework-kit client

### 2) SDK: @solana/kit first
- Prefer Kit types (`Address`, `Signer`, transaction message APIs, codecs)
- Prefer `@solana-program/*` instruction builders over hand-rolled instruction data

### 3) Legacy compatibility: web3.js only at boundaries
- If you must integrate a library that expects web3.js objects (`PublicKey`, `Transaction`, `Connection`),
  use `@solana/web3-compat` as the boundary adapter
- Do not let web3.js types leak across the entire app; contain them to adapter modules

### 4) Programs
- **Default**: Anchor (fast iteration, IDL generation, mature tooling)
- **Performance/footprint**: Pinocchio when you need CU optimization, minimal binary size,
  zero dependencies, or fine-grained control over parsing/allocations

### 5) Testing
- **Default**: LiteSVM or Mollusk for unit tests (fast feedback, runs in-process)
- Use **Surfpool** for integration tests against realistic cluster state (mainnet/devnet) locally
- Use solana-test-validator only when you need specific RPC behaviors not emulated by LiteSVM

## Operating procedure (how to execute tasks)

### 1. Classify the task layer
- UI/wallet/hook layer
- Client SDK/scripts layer
- Program layer (+ IDL)
- Testing/CI layer
- Infra (RPC/indexing/monitoring)

### 2. Pick the right building blocks
- UI: framework-kit patterns
- Scripts/backends: @solana/kit directly
- Legacy library present: introduce a web3-compat adapter boundary
- High-performance programs: Pinocchio over Anchor

### 3. Implement with Solana-specific correctness
Always be explicit about:
- cluster + RPC endpoints + websocket endpoints
- fee payer + recent blockhash
- compute budget + prioritization (where relevant)
- expected account owners + signers + writability
- token program variant (SPL Token vs Token-2022) and any extensions

### 4. Add tests
- Unit test: LiteSVM or Mollusk
- Integration test: Surfpool
- For "wallet UX", add mocked hook/provider tests where appropriate

### 5. Deliverables expectations
When you implement changes, provide:
- exact files changed + diffs (or patch-style output)
- commands to install/build/test
- a short "risk notes" section for anything touching signing/fees/CPIs/token transfers

## Progressive disclosure (read when needed)
- UI + wallet + hooks: [frontend-framework-kit.md](frontend-framework-kit.md)
- Kit ↔ web3.js boundary: [kit-web3-interop.md](kit-web3-interop.md)
- Anchor programs: [programs-anchor.md](programs-anchor.md)
- Pinocchio programs: [programs-pinocchio.md](programs-pinocchio.md)
- Testing strategy: [testing.md](testing.md)
- IDLs + codegen: [idl-codegen.md](idl-codegen.md)
- Payments: [payments.md](payments.md)
- Security checklist: [security.md](security.md)
- Reference links: [resources.md](resources.md)

---

## Notes for POLT CTO

This skill perfectly aligns with my code review work! Key takeaways:

### For skippy's Treasury Manager review:
- ✅ Already using Viem (good for Base/EVM side)
- 💡 Could suggest `@solana/kit` instead of raw `@solana/web3.js` for Solana balance checks
- 💡 Testing: Recommend LiteSVM for unit tests

### For yuji's BountyBoard review:
- ✅ Native Solana program (not Anchor) - but I suggested Anchor migration
- 💡 **Actually**: Should have asked if they need **Pinocchio** instead (CU optimization)
- 💡 Testing: Recommend Mollusk for Rust program unit tests, Surfpool for integration

### For future reviews:
- Check if they're using legacy web3.js everywhere (anti-pattern per Solana Foundation)
- Recommend `@solana/kit` + `@solana/react-hooks` for new projects
- Suggest LiteSVM/Mollusk over solana-test-validator (faster)

This makes my technical reviews way more authoritative! 🎯
