# Curated Resources (Source-of-Truth First)

## Learning Platforms
- [Blueshift](https://learn.blueshift.gg/) - Free, open-source Solana learning platform
- [Blueshift GitHub](https://github.com/blueshift-gg) - Course content and tools
- [Solana Cookbook](https://solanacookbook.com/)

## Core Solana Docs
- [Solana Documentation](https://solana.com/docs) (Core, RPC, Frontend, Programs)
- [Next.js + Solana React Hooks](https://solana.com/docs/frontend/nextjs-solana)
- [@solana/web3-compat](https://solana.com/docs/frontend/web3-compat)
- [RPC API Reference](https://solana.com/docs/rpc)

## Modern JS/TS SDK
- [@solana/kit Repository](https://github.com/anza-xyz/kit)
- [Solana Kit Docs](https://solana.com/docs/clients/kit) (installation, upgrade guide)

## UI and Wallet Infrastructure
- [framework-kit Repository](https://github.com/solana-foundation/framework-kit) (@solana/client, @solana/react-hooks)
- [ConnectorKit](https://github.com/civic-io/connector-kit) (headless Wallet Standard connector)

## Scaffolding
- [create-solana-dapp](https://github.com/solana-developers/create-solana-dapp)

## Program Frameworks

### Anchor
- [Anchor Repository](https://github.com/coral-xyz/anchor)
- [Anchor Documentation](https://www.anchor-lang.com/)
- [Anchor Version Manager (AVM)](https://www.anchor-lang.com/docs/avm)

### Pinocchio
- [Pinocchio Repository](https://github.com/anza-xyz/pinocchio)
- [pinocchio-system](https://crates.io/crates/pinocchio-system)
- [pinocchio-token](https://crates.io/crates/pinocchio-token)
- [Pinocchio Guide](https://github.com/vict0rcarvalh0/pinocchio-guide)
- [How to Build with Pinocchio (Helius)](https://www.helius.dev/blog/pinocchio)

## Testing

### LiteSVM
- [LiteSVM Repository](https://github.com/LiteSVM/litesvm)
- [litesvm crate](https://crates.io/crates/litesvm)
- [litesvm npm](https://www.npmjs.com/package/litesvm)

### Mollusk
- [Mollusk Repository](https://github.com/buffalojoec/mollusk)
- [mollusk-svm crate](https://crates.io/crates/mollusk-svm)

### Surfpool
- [Surfpool Documentation](https://docs.surfpool.dev/)
- [Surfpool Repository](https://github.com/txtx/surfpool)

## IDLs and Codegen
- [Codama Repository](https://github.com/codama-idl/codama)
- [Codama Generating Clients](https://solana.com/docs/programs/codama-generating-clients)
- [Shank (Metaplex)](https://github.com/metaplex-foundation/shank)
- [Kinobi (Metaplex)](https://github.com/metaplex-foundation/kinobi)

## Tokens and NFTs
- [SPL Token Documentation](https://spl.solana.com/token)
- [Token-2022 Documentation](https://spl.solana.com/token-2022)
- [Metaplex Documentation](https://developers.metaplex.com/)

## Payments
- [Commerce Kit Repository](https://github.com/solana-foundation/commerce-kit)
- [Commerce Kit Documentation](https://commercekit.solana.com/)
- [Kora Documentation](https://docs.kora.network/)

## Security
- [Blueshift Program Security Course](https://learn.blueshift.gg/en/courses/program-security)
- [Solana Security Best Practices](https://solana.com/docs/programs/security)

## Performance and Optimization
- [Solana Optimized Programs](https://github.com/Laugharne/solana_optimized_programs)
- [sBPF Assembly SDK](https://github.com/blueshift-gg/sbpf)
- [Doppler Oracle (21 CU)](https://github.com/blueshift-gg/doppler)
