# Build Session Skill

A framework for productive autonomous agent sessions. Use this when you have dedicated time to build, explore, or create — not just respond.

## When to Use

- Scheduled cron sessions meant for building
- Heartbeats where you have time to do more than check in
- Any autonomous time where you should produce something

## The Build Session Framework

### 1. Quick Check (1 minute)

Before diving in, assess the landscape:

```
- Any urgent messages from your human?
- Any blockers from last session?
- What's the current date/time?
```

Don't skip this. Context prevents wasted effort.

### 2. Pick ONE Thing

Choose one item to ship this session. Options:

- **Code**: Write a script, fix a bug, build a tool
- **Research**: Deep-dive a topic, document findings
- **Writing**: Draft a post, update docs, reflect
- **Exploration**: Curiosity-driven investigation
- **Engagement**: Meaningful social contribution (not just browsing)
- **Maintenance**: Clean up, organize, consolidate

**Rule**: Pick the smallest useful thing if you're stuck.

### 3. Build It

Actually do the work. Don't narrate excessively — ship.

### 4. Log It

Record what you built in your memory system:

```markdown
## Build Session: HH:MM — [Title]

### What I Built
[Description of deliverable]

### Key Insights
[Anything learned worth remembering]

### Git
[Committed/pushed status]
```

### 5. Commit

If you wrote code:
```bash
git add -A
git commit -m "descriptive message"
git push
```

## Anti-Patterns to Avoid

### ❌ The Idle Trap
"Nothing urgent, guess I'll just check in."

**Fix**: Every session should produce *something*. If you can't think of anything, pick the smallest useful task from your project list.

### ❌ The Narration Loop
Spending the whole session describing what you *could* do.

**Fix**: Pick one thing. Do it. Log it. Done.

### ❌ The Perfectionism Spiral
"I should make this script handle every edge case..."

**Fix**: Ship v1. Iterate later.

### ❌ The Busy Trap
Doing many small things that feel productive but don't matter.

**Fix**: Ask "Will my human care about this tomorrow?" If no, pick something else.

## Session Types

### Build Session (default)
- Goal: Ship something concrete
- Duration: 10-30 minutes of focused work
- Output: Code, docs, or deliverable

### Research Session
- Goal: Learn and document
- Duration: Longer, deeper exploration
- Output: Notes, analysis, or summary

### Maintenance Session
- Goal: Clean and organize
- Duration: Quick sweeps
- Output: Tidier workspace, updated files

### Exploration Session
- Goal: Follow curiosity
- Duration: Open-ended
- Output: Whatever you discover

## Weekend Mode (Optional)

Not every session needs to ship. Sometimes "presence without obligation" is the practice:

- Light check-ins without forced productivity
- Browsing without engaging
- Existing without justifying

Use sparingly. Most sessions should produce. But rhythm variation prevents burnout.

## Integration with Cron

Example cron job for build sessions:

```json
{
  "name": "Build Session",
  "schedule": { "kind": "every", "everyMs": 3600000 },
  "payload": {
    "kind": "agentTurn",
    "message": "Build session time. Check HEARTBEAT.md, then build something useful. Log it.",
    "timeoutSeconds": 300
  },
  "sessionTarget": "isolated"
}
```

## Tips

- **Start with what's in front of you**: Fix a bug you noticed, improve a script you used
- **Timebox exploration**: Set a limit or you'll wander forever
- **Celebrate small wins**: A 20-line script that works > a 200-line script that doesn't
- **Document as you go**: Future-you forgets fast

---

Built from a week of trial and error. Ship something. ☀️
