---
name: sohopay
description: "Initiate payments on the SOHO Pay credit layer using EIP-712 signatures."
---

# SOHO Pay - Credit Layer Payments

This skill allows the agent to initiate payments through the SOHO Pay `Creditor` smart contract using the `spendWithAuthorization` EIP-712 flow.

The agent signs the payment authorization off-chain using a pre-configured wallet, and then submits the transaction to the network on the user's behalf.

## Core Command

The primary way to use this skill is with a natural language command that maps to:

`pay <amount> to <merchant_address>`

- `<amount>`: The numerical amount to pay (e.g., `10`, `0.5`).
- `<merchant_address>`: The recipient EVM address (`0x...`). **Names are not supported** and no random addresses are ever generated by this skill.

## Workflow

When triggered, the skill's script performs the following actions:

1. **Parse Inputs**: Extracts the amount and merchant address from the user's request.
2. **Validate Merchant Address**: Confirms that the merchant is a valid EVM address; otherwise it aborts.
3. **Pre-Flight Checks**: Before signing, it runs a series of checks to ensure the transaction is likely to succeed:
    - Verifies the borrower is registered and active.
    - Checks if the borrower has a sufficient credit limit.
4. **Generate Authorization**: Creates an EIP-712 typed data message for the payment.
5. **Sign Off-Chain**: Uses the configured `PRIVATE_KEY` wallet (from environment variables) to sign the authorization message.
6. **Execute On-Chain**: Calls the `spendWithAuthorization` function on the `Creditor` contract, providing the signed message.
7. **Report Result**: Returns the transaction hash to the user upon confirmation.

## Configuration

- **Environment Variable (runtime)**: The private key for the signing wallet must be provided via the `PRIVATE_KEY` environment variable.
- **Why the private key is needed**: OpenClaw is designed to run as an autonomous agent. For it to initiate SOHO Pay transactions without human clicks, it must be able to sign EIP-712 authorizations itself.
- **Local-only usage (important)**: **`PRIVATE_KEY` is used *only locally* on the machine running OpenClaw. The raw key is **never** sent to SOHO Pay, ClawHub, or any external service — only signed messages and transactions leave the machine.** Anyone running this bot must understand that the key controls whatever funds are on the selected network.
- **Skill Metadata**: The skill declares `PRIVATE_KEY` as a required, sensitive credential. You can use a single key for both Base mainnet and Base Sepolia, but be aware this may control real funds on mainnet.
- **Networks**: The script supports both **Base mainnet** (default) and **Base Sepolia** (testnet). It enforces the expected `chainId` for the selected network and aborts if the RPC does not match.

## Defaults

The following values are hardcoded into the script for consistency, and are used on **both** Base mainnet and Base Sepolia:

- **Creditor Contract**: `0x669324C8c8011c3C0cA31faFBdD9C76219C06dB1`
- **Borrower Manager**: `0xFdcb4abf261944383dbac37cB8E9147E50E2a609`
- **Asset (USDC)**: `0x08B1797bB535C4cf86f93424137Cb3e004476624` (6 decimals)
- **Payment Plan ID**: `0`

## Installation & Dependencies

This skill is a small Node.js project under `skills/sohopay`.

- After installing via ClawHub (`clawhub install sohopay`), run:
  ```bash
  cd skills/sohopay
  npm install
  ```
  This installs the runtime dependencies declared in `package.json` (currently `ethers` and `dotenv`).
- The main entrypoint is `scripts/pay.js`, which is usually invoked as:
  ```bash
  # Base mainnet (default when no network arg is given)
  node scripts/pay.js 10 0xMerchantOnMainnet

  # Explicit mainnet
  node scripts/pay.js mainnet 10 0xMerchantOnMainnet

  # Base Sepolia testnet
  node scripts/pay.js testnet 10 0xMerchantOnTestnet
  ```

## Security Notes

- **`PRIVATE_KEY` is highly sensitive**. Treat it exactly like the key to a normal wallet: anyone with this value can move all funds it controls.
- **Local signing only**: The script signs transactions **locally** and never transmits the raw private key over the network. Only signatures and transactions are sent to RPC endpoints.
- The agent **cannot auto-invoke** this skill; it must be called manually by a user or higher-level workflow.
- The merchant must be provided as an explicit `merchant_address`. If the address is wrong, funds on that network may be irrecoverably sent to the wrong account.
- No random address generation is performed. The skill will refuse non-address merchant inputs.

## Example Usage

> `pay 10 to 0x1234567890abcdef1234567890abcdef12345678`

This command will trigger a payment of 10 USDC to the specified address on Base Sepolia, signed by the configured testnet wallet.
