---
name: social-sentiment
description: "Sentiment analysis for brands and products across Twitter, Reddit, and Instagram. Monitor public opinion, track brand reputation, detect PR crises, surface complaints and praise at scale — analyze 70K+ posts with bulk CSV export and Python/pandas. Social listening and brand monitoring powered by 1.5B+ indexed posts."
homepage: https://xpoz.ai
metadata:
  {
    "openclaw":
      {
        "requires":
          {
            "bins": ["mcporter"],
            "skills": ["xpoz-setup"],
            "network": ["mcp.xpoz.ai"],
            "credentials": "Xpoz account (free tier) — auth via xpoz-setup skill (OAuth 2.1)",
          },
        "install": [{"id": "node", "kind": "node", "package": "mcporter", "bins": ["mcporter"], "label": "Install mcporter (npm)"}],
      },
  }
tags:
  - sentiment-analysis
  - brand-monitoring
  - social-media
  - twitter
  - reddit
  - instagram
  - analytics
  - brand-sentiment
  - reputation
  - social-listening
  - opinion-mining
  - brand-tracking
  - competitor-analysis
  - public-opinion
  - crisis-detection
  - NLP
  - reputation
  - mcp
  - xpoz
  - opinion
  - market-research
---

# Social Sentiment

**Analyze brand sentiment from live social conversations at scale.**

Surfaces themes, flags viral complaints, compares competitors. Analyzes 1K-70K posts via bulk CSV + Python.

## Setup

Run `xpoz-setup` skill. Verify: `mcporter call xpoz.checkAccessKeyStatus`

## 4-Step Process

### Step 1: Search Platforms

Queries: (1) `"Brand"` (2) `"Brand" AND (slow OR buggy)` (3) `"Brand" AND (love OR amazing)`

```bash
mcporter call xpoz.getTwitterPostsByKeywords query='"Notion"' startDate="YYYY-MM-DD"
mcporter call xpoz.checkOperationStatus operationId="op_..." # Poll 5s
```

Repeat for Reddit/Instagram. Default: 30 days.

### Step 2: Download CSVs

Use `dataDumpExportOperationId`, poll with `checkOperationStatus` for download URL (up to 64K rows).

### Step 3: Analyze

Python/pandas:

```python
import pandas as pd
df = pd.read_csv('/tmp/twitter-sentiment.csv')

POSITIVE = ['love', 'amazing', 'best', 'recommend']
NEGATIVE = ['hate', 'terrible', 'worst', 'broken']

def classify(text):
    t = str(text).lower()
    pos = sum(1 for k in POSITIVE if k in t)
    neg = sum(1 for k in NEGATIVE if k in t)
    return 'positive' if pos>neg else ('negative' if neg>pos else 'neutral')

df['sentiment'] = df['text'].apply(classify)
```

Extract themes, find viral by engagement. Customize keywords.

### Step 4: Report

```
Sentiment: 72/100 | Posts: 14,832
😊 58% | 😠 24% | 😐 18%

Themes: Performance (2K, 81% neg), UX (1.8K, 72% pos)
Viral: [Top 10]
```

Score: Engagement-weighted, 0-100. Include insights.

## Tips

Download full CSVs | Reddit = honest | Store `data/social-sentiment/` for trends
