# Hashtag Research Guide

## How to Generate Hashtags

### Method 1: Topic-Based
1. Identify core topic keywords
2. Find related terms
3. Mix broad + niche hashtags
4. Check trending tags in category

### Method 2: Competitor Analysis
1. Look at top performers in niche
2. Note their hashtag patterns
3. Adapt (don't copy exactly)

### Method 3: Platform Suggestions
- Twitter: Check "Trending" section
- Instagram: Use search autocomplete
- LinkedIn: Follow industry hashtags

## Hashtag Categories

### Broad (1M+ posts)
High visibility, high competition
- #technology #business #marketing #startup

### Niche (100K-1M posts)
Targeted audience, moderate competition
- #SaaS #contentmarketing #techstartup

### Micro (10K-100K posts)
Highly targeted, loyal communities
- #indiehacker #buildinpublic #solopreneur

### Branded
Your own tags for campaigns
- #YourBrandName #YourCampaign

## Best Practices

**DO:**
- Mix hashtag sizes
- Keep them relevant
- Research before using
- Create branded tags

**DON'T:**
- Use banned/spammy tags
- Overload posts (except Instagram)
- Use irrelevant trending tags
- Same tags on every post

## Platform Limits

| Platform | Recommended | Max |
|----------|-------------|-----|
| Twitter | 2-3 | No limit (but ugly) |
| LinkedIn | 3-5 | No official limit |
| Instagram | 10-15 | 30 |
| Facebook | 1-3 | No limit |
| TikTok | 3-5 | No limit |
