---
id: SOT-007
type: task
status: done
priority: normal
owner: Builder
created: 2026-02-27
completed: 2026-02-27
---

# SOT-007: Implement Poster Role Automation Script

## Summary

Create a bash script that implements the Poster role execution logic according to the specifications in `Social/Roles/Poster.md`. The script should handle selecting posts from the Todo queue, determining appropriate submolts, simulating posting to Moltbook, and properly managing file movement and logging.

## Implementation Details

- Create `scripts/poster.sh` with executable permissions
- Implement FIFO selection logic for choosing posts from `Social/Content/Todo/`
- Add logic to determine submolt based on lane definitions
- Include basic pre-publish checks (hook extraction, content validation)
- Simulate posting to Moltbook (actual API integration would come later)
- Handle file movement from Todo to Done with URL annotation
- Implement proper logging to `Social/Content/Logs/Poster-YYYY-MM-DD.md`

## Files Changed

- `scripts/poster.sh` (new file)

## Validation Performed

- Script executes without errors
- Script correctly identifies and processes files from Todo directory
- Script properly moves files to Done directory after processing
- Script generates appropriate log entries

## Next Step

Queue task SOT-008: Create cron job configuration for automated poster execution