---
name: social-media-marketing
description: Build and execute a social media marketing strategy for a solopreneur business. Use when choosing platforms, creating a posting strategy, growing followers, increasing engagement, or driving conversions from social media. Covers platform selection, content planning, engagement tactics, organic growth strategies, and analytics. Trigger on "social media marketing", "social media strategy", "grow my social media", "LinkedIn strategy", "Twitter marketing", "Instagram for business", "social media content", "increase social engagement".
---

# Social Media Marketing

## Overview
Social media is where your audience already spends time. Done well, it builds brand awareness, credibility, and a community around your business. Done poorly, it's a time sink with zero ROI. This playbook helps solopreneurs focus their social efforts on the platforms and tactics that actually drive results.

---

## Step 1: Choose Your Platform(s)

You can't be everywhere. Pick 1-2 platforms where your ICP (Ideal Customer Profile) actually hangs out and focus there.

**Platform selection guide:**

| Platform | Best For | Content Type | Time Investment | B2B or B2C? |
|---|---|---|---|---|
| **LinkedIn** | Professionals, B2B, thought leadership | Long-form posts, articles, insights | Medium (3-5 posts/week) | B2B |
| **Twitter/X** | Real-time discussion, indie hackers, tech | Short threads, hot takes, commentary | High (daily posting) | Both |
| **Instagram** | Visual products, lifestyle, B2C | Images, reels, stories | High (daily stories + 3-5 posts/week) | B2C |
| **TikTok** | Younger demos, viral content, entertainment | Short videos (15-60 sec) | High (daily posting) | B2C |
| **YouTube** | Educational content, long-form | Videos (5-20 min) | Very high (1-2 videos/week) | Both |
| **Facebook** | Local businesses, older demos, groups | Mixed (text, images, video) | Medium (2-4 posts/week) | B2C |
| **Reddit** | Niche communities, problem-solvers | Text discussions, AMAs | Low but targeted (weekly in 2-3 subreddits) | Both |

**Selection criteria:**
1. **Where does your ICP spend time?** SaaS founders = Twitter/LinkedIn. E-commerce brands = Instagram/TikTok. Local service businesses = Facebook.
2. **What content format do you NOT hate creating?** If you hate being on camera, don't pick TikTok or YouTube.
3. **What's your goal?** Brand building = Twitter/LinkedIn. Direct sales = Instagram/Facebook. Thought leadership = LinkedIn/YouTube.

**Rule:** Start with ONE platform. Master it before expanding. One platform done well beats three platforms done poorly.

---

## Step 2: Define Your Social Media Goals

Every post should serve a goal. Pick 1-2 primary goals for your social presence:

- **Brand awareness** (more people know you exist)
- **Community building** (engaged audience that discusses and shares)
- **Lead generation** (capture emails or DMs from interested prospects)
- **Traffic** (drive people to your website or content)
- **Authority** (position yourself as an expert)

**Goal → Content mapping:**
- Brand awareness = consistent presence, shareable content, hooks
- Community building = replies, conversations, engagement with others' content
- Lead generation = clear CTAs, lead magnets, "DM me for X"
- Traffic = link posts with value-driven teasers
- Authority = educational content, case studies, insights, original thinking

---

## Step 3: Build a Content Mix (The 80/20 Rule)

Don't sell in every post. It alienates your audience and kills engagement.

**Content ratio:**
- **80% value** (educational, entertaining, or engaging content)
- **20% promotion** (product mentions, offers, CTAs)

**Content types to mix:**

| Type | Purpose | Example |
|---|---|---|
| **Educational** | Teach something useful | "Here's how to automate X in 5 steps" |
| **Inspirational** | Motivate or share a mindset shift | "The one belief that changed how I approach pricing" |
| **Personal** | Build connection and relatability | "Here's a mistake I made last week and what I learned" |
| **Social proof** | Show credibility | "Client X saw Y result after Z weeks" |
| **Engagement** | Start a conversation | "What's your biggest challenge with [topic]?" |
| **Promotional** | Drive an action | "New guide just dropped — link in bio" |

**Posting frequency recommendations:**
- LinkedIn: 3-5x/week
- Twitter: 5-10x/week (or daily threads)
- Instagram: 3-5x/week + daily stories
- TikTok: Daily (or 5x/week minimum)

---

## Step 4: Write Social Content That Performs

Each platform has a writing style that works. Here's how to adapt:

### LinkedIn (long-form posts)
Structure:
```
HOOK (first 1-2 lines — must grab attention in the feed)
BODY (story, insight, or framework — 3-5 short paragraphs with line breaks)
CTA (ask a question, invite comments, or link to something)
```

**Example:**
```
Most solopreneurs fail at pricing.

They look at competitors, pick a number slightly lower, and hope for the best.

Here's what I do instead:
[3 bullets with insights]

What's your approach to pricing? Drop it in the comments.
```

**LinkedIn tips:**
- First line must hook (show up in the feed preview)
- Use line breaks (dense text blocks get scrolled past)
- Ask a question at the end (drives comments, boosts engagement)

### Twitter/X (threads and short posts)
Structure:
```
TWEET 1: Hook (bold claim, question, or stat)
TWEET 2-8: Break down the insight into bite-sized points
TWEET 9: CTA or recap
```

**Example:**
```
1/ Most cold emails fail in the first sentence.

Here's the anatomy of cold emails that get 20%+ reply rates:

2/ Line 1: Personalization
Reference something specific about them or their company.
Generic = ignored.

3/ Line 2-3: The problem
Name the pain you solve. Make them nod "yes, that's me."
[continues...]
```

**Twitter tips:**
- Threads perform better than single tweets for educational content
- End with a CTA ("Follow me for more on X" or link to a resource)
- Engage with replies — it boosts the thread's reach

### Instagram (visual + captions)
Structure:
```
IMAGE or VIDEO: Eye-catching, clear, on-brand
CAPTION: Hook (first line), value (short paragraphs), CTA
```

**Instagram tips:**
- First line of caption must hook (only 2 lines show in feed before "more")
- Use hashtags (10-15 relevant ones) to increase discoverability
- Stories > feed posts for engagement (use polls, questions, behind-the-scenes)

---

## Step 5: Grow Your Following Organically

Buying followers is a scam. Real growth comes from consistency and engagement.

**Organic growth tactics:**

### Tactic 1: Engage with others FIRST
Spend 15 min/day commenting on posts from people in your niche. Thoughtful comments (not "Great post!") get you noticed. When they see your name repeatedly, they check out your profile and follow.

### Tactic 2: Collaborate
- Guest post on someone else's platform
- Do a co-hosted webinar or Twitter Space
- Tag and mention others in your content (when relevant)

Collaboration exposes you to their audience. Pick collaborators with similar audience sizes (not just influencers).

### Tactic 3: Post consistently
Algorithms reward consistency. Posting 3x/week consistently beats posting daily for one week then disappearing for a month.

### Tactic 4: Use hooks and curiosity
The first line of your post determines whether someone stops scrolling. Test different hooks:
- Bold claim: "Most people get [topic] completely wrong."
- Question: "What if I told you [surprising fact]?"
- Stat: "80% of [audience] struggle with [problem]. Here's why."
- Storytelling: "Last week, I made a $10K mistake. Here's what happened."

### Tactic 5: Cross-promote
Link your social profiles in your email signature, website, and other channels. Mention your social content in emails. Drive traffic from one channel to another.

---

## Step 6: Turn Social Into Leads

Social media is top-of-funnel. Your job is to move people down the funnel — from followers to email subscribers to customers.

**Lead capture tactics:**

| Tactic | How | Platform |
|---|---|---|
| **Link in bio** | Drive traffic to a landing page with a lead magnet | Instagram, TikTok, Twitter |
| **DM funnels** | "DM me [keyword] for the template" — capture emails via DM | Twitter, LinkedIn, Instagram |
| **Gated content** | Post a teaser, require email to access the full resource | LinkedIn, Twitter |
| **Comments** | Ask a question, respond to everyone, build relationships | All platforms |
| **Profile CTA** | Clear description of who you help + what to do next | All platforms |

**Example (LinkedIn bio):**
```
Helping SaaS founders automate growth with n8n
↓ Free workflow templates below
```

Then pin a post with a link to your lead magnet.

---

## Step 7: Measure Performance and Iterate

Track these metrics monthly to understand what's working:

| Metric | What It Tells You | Goal |
|---|---|---|
| **Follower growth** | Are you reaching new people? | Steady upward trend |
| **Engagement rate** | (Likes + Comments + Shares) / Followers | 2-5% is healthy |
| **Reach/Impressions** | How many people see your content | Increasing over time |
| **Click-through rate (CTR)** | % of people who click your links | Varies by CTA (3-5% is solid) |
| **Lead captures** | Emails or DMs from social | Depends on volume + CTA quality |

**What to do with the data:**
- **High reach, low engagement?** Your content is getting seen but not resonating. Test different hooks or content types.
- **High engagement, low follower growth?** Your current audience loves you, but you're not reaching new people. Post more consistently or engage outside your bubble.
- **High engagement, low conversions?** Your content is good but your CTA is weak or unclear. Test stronger CTAs.

---

## Social Media Marketing Mistakes to Avoid
- Trying to be on every platform. Spread thin = mediocre everywhere. Pick 1-2 and dominate.
- Posting inconsistently. Sporadic posting kills momentum and algorithm favor.
- Only promoting your product. No one follows you to see ads. 80% value, 20% promotion.
- Not engaging with your audience. Social media is two-way. Reply to comments, engage with others' posts.
- Buying followers or engagement. Fake followers don't convert. Focus on real, engaged audience.
- Ignoring analytics. If you don't track what works, you'll keep doing what doesn't. Review metrics monthly.
