# Content Writing & Thought Leadership

**B2B SaaS content writing with daily workflows, batching systems, and industry-specific templates across Sales Tech, HR Tech, Fintech, and Ops Tech.**

Created by [Shashwat Ghosh](https://linkedin.com/in/shashwatghosh-ai-b2b-gtm-fractionalcmo) - Founder of Helix GTM Consulting

---

## 📋 Table of Contents

- [What This Skill Does](#what-this-skill-does)
- [What This Skill Cannot Do](#what-this-skill-cannot-do)
- [Industry Coverage](#industry-coverage)
- [Key Features](#key-features)
- [Use Cases](#use-cases)
- [Installation](#installation)
- [Examples](#examples)
- [Author](#author)

---

## ✅ What This Skill Does

This skill provides comprehensive content writing frameworks and workflows for B2B SaaS thought leadership:

### Core Capabilities:

1. **Content Strategy Frameworks**
   - Daily content creation workflows
   - Weekly batching systems for efficiency
   - Monthly content calendar planning
   - Quarterly thought leadership themes
   - Content repurposing strategies (1 piece → 10 formats)

2. **Platform-Specific Content**
   - LinkedIn posts (multiple formats: text, carousel, video scripts)
   - Blog posts (SEO-optimized, 800-2000 words)
   - Twitter/X threads (attention-grabbing, viral potential)
   - Medium articles (long-form thought leadership)
   - Newsletter content (weekly/biweekly cadence)
   - Video scripts (YouTube, LinkedIn video)
   - Podcast scripts and show notes

3. **Content Type Templates**
   - Founder stories (personal journey, lessons learned)
   - Product announcements (launch messaging)
   - Customer success stories (case study format)
   - Industry trends analysis (market commentary)
   - How-to guides (tactical, actionable)
   - Opinion pieces (hot takes, contrarian views)
   - Data-driven insights (research-backed)

4. **Writing Workflows**
   - 30-minute daily writing sprint
   - 2-hour weekly batching session
   - Content ideation frameworks
   - Research and fact-checking processes
   - Editing and refinement checklists
   - Publication scheduling strategies

5. **Thought Leadership Development**
   - Personal brand positioning
   - Unique point-of-view (POV) development
   - Signature frameworks creation
   - Category creation strategies
   - Contrarian positioning techniques
   - Storytelling structures

### Industry-Specific Content:

- **Sales Tech**: Revenue strategies, pipeline management, sales enablement, conversation intelligence
- **HR Tech**: People operations, employee engagement, performance management, workplace culture
- **Fintech**: Financial innovation, compliance trends, payment systems, corporate finance
- **Ops Tech**: Operational efficiency, retail execution, logistics optimization, automation

### Supported Scenarios (24 Total):

Each vertical includes 6 content scenarios covering:
1. Founder-led thought leadership
2. Product marketing content
3. Customer success storytelling
4. Industry trend commentary
5. Educational how-to content
6. Data-driven insights

---

## ❌ What This Skill Cannot Do

### Limitations to Understand:

1. **No Automated Content Generation**
   - Cannot write content completely autonomously
   - Cannot schedule or publish content automatically
   - Cannot manage editorial calendars in tools
   - Cannot integrate with CMS platforms directly

2. **No Real-Time Trend Monitoring**
   - Cannot track trending topics automatically
   - Cannot monitor competitor content in real-time
   - Cannot alert you to viral opportunities
   - Cannot scrape social media for content ideas

3. **No SEO Tools Integration**
   - Cannot perform keyword research automatically
   - Cannot check SEO scores in real-time
   - Cannot analyze backlinks or domain authority
   - Cannot integrate with Ahrefs, SEMrush, etc.

4. **No Multi-Language Translation**
   - Frameworks optimized for English content
   - Cannot automatically translate to other languages
   - May not adapt well to non-English content norms
   - Cultural context requires manual adaptation

5. **No Brand Voice Cloning**
   - Cannot automatically match existing brand voice
   - Cannot analyze and replicate writing style
   - Requires manual brand guidelines input
   - Cannot guarantee consistency without editing

6. **No Content Performance Analytics**
   - Cannot track engagement metrics automatically
   - Cannot measure conversion rates
   - Cannot A/B test content automatically
   - Cannot integrate with analytics platforms

7. **Limited Legal/Compliance Review**
   - Does not replace legal review for regulated industries
   - Cannot ensure compliance with advertising laws
   - Cannot verify claims or statistics automatically
   - Cannot protect against copyright issues

---

## 🏢 Industry Coverage

### Fully Supported Verticals:

1. **Sales Tech (6 content scenarios)**
   - Topics: Sales productivity, revenue intelligence, pipeline management, sales enablement
   - Formats: LinkedIn posts, blog posts, case studies, webinar scripts
   - Audience: Sales leaders, CROs, RevOps professionals
   - Examples: "How AI is changing sales coaching" / "5 mistakes in pipeline management"

2. **HR Tech (6 content scenarios)**
   - Topics: Employee engagement, performance management, workplace culture, remote work
   - Formats: LinkedIn articles, thought leadership, research reports, newsletters
   - Audience: CHROs, HR leaders, People Ops professionals
   - Examples: "The future of performance reviews" / "Building culture in hybrid teams"

3. **Fintech (6 content scenarios)**
   - Topics: Payment innovation, corporate finance, expense management, compliance
   - Formats: Blog posts, white papers, regulatory updates, industry analysis
   - Audience: CFOs, Finance leaders, Controllers
   - Examples: "RBI's new guidelines explained" / "Corporate card ROI calculator"

4. **Ops Tech (6 content scenarios)**
   - Topics: Retail execution, logistics optimization, field force automation, distribution
   - Formats: Case studies, how-to guides, industry reports, customer stories
   - Audience: Operations leaders, Supply chain professionals, Retail managers
   - Examples: "Improving retail execution in Kirana stores" / "Last-mile delivery optimization"

### Adaptable to Other Verticals:

- **Marketing Tech**: Adapt Sales Tech templates
- **Customer Success Tech**: Adapt HR Tech templates
- **Data/Analytics**: Adapt Ops Tech templates
- **DevOps/Infrastructure**: Adapt Ops Tech templates

---

## 🎯 Key Features

### 1. Daily Writing Workflows

**30-Minute Daily Sprint:**
- 5 min: Choose topic from ideation bank
- 20 min: First draft (don't edit!)
- 5 min: Schedule for later editing

**Morning Writing Ritual:**
- Write before checking email/Slack
- No research during writing time
- Capture ideas immediately
- Edit separately (not while writing)

**Evening Review:**
- Review morning draft
- Light editing (10 minutes max)
- Schedule for next-day posting
- Bank unused content

### 2. Weekly Batching System

**2-Hour Weekly Session:**
- Monday: Ideate (20 topics for the week)
- Wednesday: Write (5 pieces in 2 hours)
- Friday: Edit and schedule (all at once)

**Benefits:**
- Reduces context-switching
- Maintains writing momentum
- Ensures consistent pipeline
- Improves quality through focus

### 3. Content Repurposing Framework

**1 Piece → 10 Formats:**
1. Original blog post (800-1500 words)
2. LinkedIn article (same content)
3. Twitter thread (10-15 tweets)
4. LinkedIn carousel (8-10 slides)
5. Instagram carousel (adapted)
6. Newsletter section (excerpt + link)
7. YouTube script (5-7 minutes)
8. Podcast talking points
9. Email campaign (3-email series)
10. Guest post (revised for other blogs)

### 4. Thought Leadership Templates

**The Personal Journey:**
- Hook: Surprising moment/realization
- Context: Where you were before
- Insight: What you learned
- Application: How others can use it
- Call-to-action: Engage with readers

**The Contrarian Take:**
- Popular belief: What everyone thinks
- Why it's wrong: Evidence/experience
- Better approach: Your alternative
- Proof: Data or examples
- Invitation: Join the conversation

**The How-To Guide:**
- Problem: What readers struggle with
- Framework: Your step-by-step system
- Example: Real application
- Common mistakes: Pitfalls to avoid
- Resources: Tools/links to help

### 5. Platform-Specific Guidelines

**LinkedIn Posts:**
- Length: 150-300 words (optimal engagement)
- Hook: First 2 lines must grab attention
- Structure: Short paragraphs, white space
- CTA: Ask a question, invite comments
- Timing: Tuesday-Thursday, 8-10 AM IST

**Blog Posts:**
- Length: 1200-1800 words (SEO sweet spot)
- Structure: H2/H3 headings, bullet points
- Images: 1 image per 300 words
- Links: Internal + external (2-3 each)
- CTA: Newsletter signup, book demo

**Twitter/X Threads:**
- Length: 8-12 tweets (optimal completion rate)
- Hook: Tweet 1 must stop scrolling
- Format: 1 idea per tweet, numbered
- Visuals: Add 1-2 images in thread
- CTA: Final tweet with link/ask

---

## 💼 Use Cases

### For Founders:
- Build personal brand alongside company brand
- Share founder journey and lessons learned
- Attract investors through thought leadership
- Recruit talent by showcasing culture
- Generate inbound leads through content

### For Marketing Teams:
- Create consistent content pipeline
- Support multiple channels simultaneously
- Generate leads through SEO-optimized content
- Build industry authority
- Support sales enablement with content

### For Product Marketers:
- Launch products with compelling narratives
- Create educational content for prospects
- Develop customer case studies
- Position against competitors
- Build category awareness

### For Executives:
- Establish thought leadership in industry
- Share insights from board meetings/strategy
- Comment on industry trends
- Build professional network
- Prepare for speaking engagements

### For Content Writers:
- Overcome writer's block with templates
- Speed up content creation with frameworks
- Maintain quality across high volume
- Develop unique writing voice
- Scale content operations

---

## 📦 Installation

### Method 1: Using Clawd CLI

```bash
clawdhub install shashwatgtm/content-writing-thought-leadership
```

### Method 2: Using Claude.ai

1. Download the `SKILL.md` file from this repository
2. Go to Claude.ai → Settings → Skills
3. Click "Upload Skill" and select the file
4. The skill will be available in all your conversations

### Method 3: Using Claude Desktop

1. Download the `SKILL.md` file
2. Open Claude Desktop → Settings → Skills
3. Add the skill file
4. Enable for use in conversations

---

## 📚 Examples

### Example 1: LinkedIn Post Creation

**Prompt:**
```
I'm a Sales Tech founder. Write a LinkedIn post about "Why most sales coaching fails" 
using the Contrarian Take template. Make it 200 words, engaging hook, personal story.
```

**The skill will provide:**
- Contrarian hook: "Everyone thinks sales coaching needs more data. They're wrong."
- Personal story: Your experience with over-engineered coaching
- Better approach: Simple, consistent, coach-in-the-moment
- Engagement question: "What's your experience with sales coaching?"
- Formatting: Optimized for LinkedIn (short paragraphs, white space)

---

### Example 2: Blog Post Outline

**Prompt:**
```
Create a blog post outline for "The Complete Guide to Retail Execution in India" 
(Operations Tech, 1500 words, SEO-optimized for "retail execution software")
```

**The skill will provide:**
- SEO-optimized title and meta description
- H2/H3 heading structure (7-9 sections)
- Introduction framework (problem → solution → preview)
- Content for each section (what to include)
- Internal/external linking opportunities
- CTA recommendation (demo request, guide download)

---

### Example 3: Content Batching Plan

**Prompt:**
```
I'm an HR Tech CMO. Create a weekly content batching plan: 5 LinkedIn posts, 
1 blog post, 1 newsletter section. Topics around "employee engagement trends 2026"
```

**The skill will provide:**
- Monday ideation: 7 topic ideas (choose 5 for LinkedIn)
- Wednesday writing session: Order of creation (blog first, then LinkedIn)
- LinkedIn post angles: 5 different perspectives on engagement
- Blog post: "State of Employee Engagement 2026: What's Changing"
- Newsletter excerpt: Key insights from blog
- Repurposing plan: Turn blog into Twitter thread + carousel

---

### Example 4: Thought Leadership Series

**Prompt:**
```
I want to position myself as a fintech thought leader. Create a 90-day content plan 
with signature framework, regular posting schedule, and topic themes.
```

**The skill will provide:**
- Signature framework: "The 4 Pillars of Fintech Compliance" (example)
- Weekly themes: Month 1 (Problem), Month 2 (Solution), Month 3 (Future)
- Content calendar: 3× weekly LinkedIn, 1× weekly blog, 1× monthly deep-dive
- Topic progression: Build on each piece
- Engagement tactics: How to spark conversations
- Measurement: What to track (followers, engagement, inbound leads)

---

## 🔧 Integration & Workflow

### Works Best With:

**Content Management:**
- Notion (organize content calendar)
- Airtable (track content ideas)
- Google Docs (drafting and collaboration)

**Scheduling Tools:**
- Buffer, Hootsuite (social media)
- Medium (publishing)
- Substack (newsletters)

**Research Tools:**
- Google Trends (topic validation)
- AnswerThePublic (question research)
- BuzzSumo (competitor content analysis)

### Typical Workflow:

1. **Ideation** (Monday, 30 minutes)
   - Use skill to generate 20 topic ideas
   - Filter to 7 best ideas (1 per day)
   - Add to content calendar

2. **Batching** (Wednesday, 2 hours)
   - Write first drafts (all 7 pieces)
   - Use templates from skill
   - Don't edit, just write

3. **Editing** (Friday, 1 hour)
   - Edit Monday-Wednesday content
   - Add links, images, formatting
   - Schedule for next week

4. **Publishing** (Daily, 5 minutes)
   - Review scheduled content
   - Post at optimal time
   - Engage with comments

---

## 📊 What You'll Get

### Content Templates:
- LinkedIn post templates (10+ formats)
- Blog post outlines (5 structures)
- Email newsletter templates (3 formats)
- Twitter thread frameworks (4 types)
- Video script templates (3 formats)

### Writing Tools:
- Hook formulas (15+ proven openers)
- Transition phrases (connection words)
- Call-to-action templates (engagement drivers)
- Headline formulas (attention-grabbing)
- Storytelling structures (narrative arcs)

### Workflow Systems:
- Daily writing ritual (step-by-step)
- Weekly batching system (time-blocked)
- Monthly planning framework (themes)
- Quarterly strategy review (retrospective)
- Content repurposing matrix (1 → 10)

### Industry Playbooks:
- Sales Tech content angles (20+ topics)
- HR Tech thought leadership (20+ topics)
- Fintech regulatory commentary (20+ topics)
- Ops Tech case studies (20+ topics)

---

## 🚀 Best Practices

### To Get Maximum Value:

1. **Be Consistent**: Daily writing beats sporadic bursts
2. **Batch Your Work**: Write multiple pieces in one session
3. **Repurpose Everything**: 1 blog post = 10 content pieces
4. **Start Simple**: Use templates, customize later
5. **Track What Works**: Note which content performs best

### Common Patterns:

**For New Content Creators:**
- Start: Use templates exactly as provided
- Month 2: Adapt templates to your voice
- Month 3: Create own variations
- Month 6: Develop signature style

**For Established Writers:**
- Use: Ideation frameworks (overcome blocks)
- Use: Batching systems (save time)
- Use: Repurposing frameworks (scale output)
- Skip: Basic templates (you have your style)

**For Marketing Teams:**
- Monday: Team ideation session (30 min)
- Wednesday: Individual batching (each person 2 hours)
- Friday: Cross-review and feedback
- Continuous: Central content bank (reusable)

---

## 👨‍💼 Author

**Shashwat Ghosh**  
Founder, Helix GTM Consulting | Fractional CMO for B2B SaaS

### Background:
- Former CMO at FieldAssist (until Sept 2024)
- Former VP Global Performance Marketing at Locus
- 15+ years in B2B SaaS marketing and GTM strategy
- Top 30 Product-Led Growth (PLG) Creator Worldwide (Favikon verified)
- #10 in India for Product Marketing on LinkedIn
- Published: "Offbeat AI Watch" (GitHub), "GTM Whisperer" (Substack/LinkedIn)

### Content Creation Track Record:
- 500+ LinkedIn posts (average engagement: 10K+ impressions)
- 100+ blog posts across multiple SaaS companies
- 50+ newsletter editions (GTM Whisperer)
- 30+ customer case studies
- Regular speaker at SaaS conferences

### Connect:
- 🔗 LinkedIn: [linkedin.com/in/shashwatghosh-ai-b2b-gtm-fractionalcmo](https://linkedin.com/in/shashwatghosh-ai-b2b-gtm-fractionalcmo)
- 🐦 X/Twitter: [@Shashwat_Ghosh](https://x.com/Shashwat_Ghosh)
- 📧 Substack: [shashwatghosh.substack.com](https://shashwatghosh.substack.com)
- 💻 GitHub: [@shashwatgtm](https://github.com/shashwatgtm)

### Other Skills:
- [Competitive Intelligence & Market Research](https://github.com/shashwatgtm/competitive-intelligence-market-research)
- [Social Media Management](https://github.com/shashwatgtm/social-media-management)
- [Newsletter Creation & Curation](https://github.com/shashwatgtm/newsletter-creation-curation)
- [Personal Branding & Authority](https://github.com/shashwatgtm/personal-branding-authority)

---

## 📄 License

MIT License - Free to use, modify, and distribute with attribution.

---

## 🙏 Contributing

Found an issue or have suggestions? Feel free to:
- Open an issue on GitHub
- Submit a pull request
- Contact me directly via LinkedIn

---

## ⭐ Support

If this skill helps your content creation efforts, please:
- ⭐ Star this repository
- 📢 Share with your network
- 💬 Provide feedback for improvements

---

**Last Updated**: January 2026  
**Version**: 1.0  
**Status**: Production Ready ✅
