# 自媒体文案生成器 - 技术架构文档

## 1. 系统架构概览

```
┌─────────────────────────────────────────────────────────────────┐
│                        用户界面层                                │
│  ┌──────────┐  ┌──────────┐  ┌──────────┐  ┌──────────┐        │
│  │ Web 界面  │  │ 命令行   │  │ API 调用  │  │ 消息机器人│        │
│  └──────────┘  └──────────┘  └──────────┘  └──────────┘        │
└─────────────────────────────────────────────────────────────────┘
                              │
                              ▼
┌─────────────────────────────────────────────────────────────────┐
│                        网关层                                    │
│  ┌──────────────────────────────────────────────────────────┐   │
│  │  API Gateway (鉴权、限流、路由、日志)                      │   │
│  └──────────────────────────────────────────────────────────┘   │
└─────────────────────────────────────────────────────────────────┘
                              │
                              ▼
┌─────────────────────────────────────────────────────────────────┐
│                        应用服务层                                │
│  ┌────────────┐ ┌────────────┐ ┌────────────┐ ┌────────────┐   │
│  │文案生成服务│ │模板管理服务│ │用户偏好服务│ │内容审核服务│   │
│  └────────────┘ └────────────┘ └────────────┘ └────────────┘   │
│  ┌────────────┐ ┌────────────┐ ┌────────────┐ ┌────────────┐   │
│  │历史记录服务│ │收藏管理服务│ │数据分析服务│ │文件存储服务│   │
│  └────────────┘ └────────────┘ └────────────┘ └────────────┘   │
└─────────────────────────────────────────────────────────────────┘
                              │
                              ▼
┌─────────────────────────────────────────────────────────────────┐
│                        AI 引擎层                                 │
│  ┌──────────────────────────────────────────────────────────┐   │
│  │  Prompt 引擎 (模板渲染、变量替换、风格注入)                  │   │
│  └──────────────────────────────────────────────────────────┘   │
│  ┌──────────────────────────────────────────────────────────┐   │
│  │  模型适配器 (多模型支持、负载均衡、降级策略)                 │   │
│  └──────────────────────────────────────────────────────────┘   │
│  ┌──────────────────────────────────────────────────────────┐   │
│  │  后处理器 (格式优化、敏感词过滤、质量评分)                   │   │
│  └──────────────────────────────────────────────────────────┘   │
└─────────────────────────────────────────────────────────────────┘
                              │
                              ▼
┌─────────────────────────────────────────────────────────────────┐
│                        数据层                                    │
│  ┌──────────┐  ┌──────────┐  ┌──────────┐  ┌──────────┐        │
│  │ PostgreSQL│  │  Redis   │  │  MinIO   │  │ 向量数据库│        │
│  │ (主数据)  │  │ (缓存)   │  │ (文件)   │  │ ( embeddings)│    │
│  └──────────┘  └──────────┘  └──────────┘  └──────────┘        │
└─────────────────────────────────────────────────────────────────┘
```

---

## 2. 技术栈选型

### 2.1 后端技术栈

| 组件 | 技术选型 | 说明 |
|------|----------|------|
| 运行时 | Node.js 20+ / Python 3.11+ | 根据 OpenClaw 技能规范选择 |
| Web 框架 | Express / FastAPI | 轻量、高性能 |
| ORM | Prisma / SQLAlchemy | 类型安全、易维护 |
| 缓存 | Redis | 会话、热点数据缓存 |
| 队列 | Bull / Celery | 异步任务处理 |

### 2.2 AI 模型层

| 用途 | 推荐模型 | 备选方案 |
|------|----------|----------|
| 文案生成 | Qwen2.5-72B / GPT-4 | Claude 3.5, DeepSeek-V3 |
| 标题优化 | Qwen2.5-32B | 轻量模型快速迭代 |
| 内容审核 | 本地敏感词库 + API | 阿里云内容安全 |
| Embedding | bge-large-zh | text2vec, m3e |

### 2.3 数据存储

| 数据类型 | 存储方案 | 说明 |
|----------|----------|------|
| 用户数据 | PostgreSQL | 用户信息、偏好设置 |
| 文案记录 | PostgreSQL | 生成历史、收藏 |
| 模板数据 | PostgreSQL | 模板内容、分类 |
| 会话缓存 | Redis | 临时状态、限流 |
| 文件存储 | MinIO / 本地 | 图片、导出文件 |
| 向量索引 | Qdrant / Milvus | 相似文案检索 |

### 2.4 前端技术栈（如需要）

| 组件 | 技术选型 |
|------|----------|
| 框架 | React 18 + TypeScript |
| UI 库 | Ant Design / Shadcn UI |
| 状态管理 | Zustand / Jotai |
| 构建工具 | Vite |

---

## 3. 核心模块设计

### 3.1 文案生成引擎

```
┌─────────────────────────────────────────────────────────┐
│                    文案生成引擎                          │
├─────────────────────────────────────────────────────────┤
│  输入层                                                  │
│  ├── 用户输入（主题、关键词、要求）                       │
│  ├── 平台选择（小红书/公众号/微博/抖音）                 │
│  └── 参数配置（长度、语气、风格）                        │
├─────────────────────────────────────────────────────────┤
│  处理层                                                  │
│  ├── Prompt 构建器                                       │
│  │   ├── 加载平台风格模板                                │
│  │   ├── 注入用户参数                                    │
│  │   └── 添加 Few-shot 示例                              │
│  ├── 模型调用层                                          │
│  │   ├── 多模型路由                                      │
│  │   ├── 请求重试                                        │
│  │   └── 超时控制                                        │
│  └── 结果后处理                                          │
│      ├── 格式规范化                                      │
│      ├── 敏感词过滤                                      │
│      └── 质量评分                                        │
├─────────────────────────────────────────────────────────┤
│  输出层                                                  │
│  ├── 多版本文案（3-5 个）                                 │
│  ├── 标题建议（5-10 个）                                  │
│  ├── 标签推荐（5-10 个）                                  │
│  └── 优化建议                                            │
└─────────────────────────────────────────────────────────┘
```

### 3.2 Prompt 模板设计

```yaml
# 小红书文案模板示例
platform: xiaohongshu
template: |
  你是一位资深的小红书内容创作者，擅长写种草笔记。
  
  【任务】
  根据以下信息，写一篇小红书风格的种草文案：
  - 主题：{{topic}}
  - 产品类型：{{product_type}}
  - 目标人群：{{target_audience}}
  - 核心卖点：{{selling_points}}
  - 语气风格：{{tone}}
  
  【要求】
  1. 标题：15-20 字，含 2-3 个 emoji，制造好奇或痛点
  2. 正文：200-500 字，分段清晰，每段 2-3 行
  3. 表情：全文 8-15 个 emoji，自然分布
  4. 标签：10 个左右，含热门 + 精准标签
  5. 风格：真实体验感，姐妹分享口吻，避免硬广
  
  【输出格式】
  标题：[标题内容]
  
  正文：
  [正文内容]
  
  标签：#标签 1 #标签 2 #标签 3 ...
```

### 3.3 数据库设计

```sql
-- 用户表
CREATE TABLE users (
    id UUID PRIMARY KEY,
    username VARCHAR(50) UNIQUE,
    email VARCHAR(100),
    preferences JSONB,  -- 用户偏好设置
    created_at TIMESTAMP,
    updated_at TIMESTAMP
);

-- 文案记录表
CREATE TABLE copywriting_records (
    id UUID PRIMARY KEY,
    user_id UUID REFERENCES users(id),
    platform VARCHAR(20),  -- xiaohongshu, wechat, weibo, douyin
    topic VARCHAR(200),
    input_params JSONB,
    generated_content JSONB,  -- 多版本文案
    selected_version INTEGER,
    is_favorite BOOLEAN DEFAULT false,
    created_at TIMESTAMP
);

-- 模板表
CREATE TABLE templates (
    id UUID PRIMARY KEY,
    name VARCHAR(100),
    platform VARCHAR(20),
    category VARCHAR(50),
    content TEXT,
    variables JSONB,  -- 模板变量定义
    is_public BOOLEAN DEFAULT false,
    usage_count INTEGER DEFAULT 0,
    created_by UUID REFERENCES users(id),
    created_at TIMESTAMP
);

-- 标签库表
CREATE TABLE tags (
    id UUID PRIMARY KEY,
    platform VARCHAR(20),
    category VARCHAR(50),
    tag_name VARCHAR(50),
    hot_score INTEGER,  -- 热度分数
    created_at TIMESTAMP
);
```

### 3.4 API 设计

```yaml
# 文案生成
POST /api/v1/copywriting/generate
Request:
  {
    "topic": "夏季防晒霜推荐",
    "platform": "xiaohongshu",
    "tone": "轻松",
    "length": "medium",
    "extra_requirements": "突出清爽不油腻"
  }
Response:
  {
    "request_id": "uuid",
    "versions": [
      {
        "id": 1,
        "title": "标题内容",
        "content": "正文内容",
        "tags": ["#标签 1", "#标签 2"],
        "score": 0.92
      }
    ],
    "suggested_titles": [...],
    "optimization_tips": [...]
  }

# 文案优化/改写
POST /api/v1/copywriting/optimize
Request:
  {
    "original_text": "...",
    "optimization_type": "expand|condense|rewrite|polish",
    "target_platform": "xiaohongshu"
  }

# 模板管理
GET  /api/v1/templates?platform=xiaohongshu&category=beauty
POST /api/v1/templates
PUT  /api/v1/templates/:id
DELETE /api/v1/templates/:id

# 历史记录
GET /api/v1/history?page=1&limit=20
GET /api/v1/history/:id
DELETE /api/v1/history/:id

# 收藏管理
POST /api/v1/favorites/:recordId
DELETE /api/v1/favorites/:recordId
GET  /api/v1/favorites
```

---

## 4. 安全与合规

### 4.1 内容安全
- 敏感词过滤（政治、色情、暴力等）
- 广告法合规检测（极限词、虚假宣传）
- 版权风险提示
- 人工审核接口（可选）

### 4.2 数据安全
- 用户数据加密存储
- API 访问 Token 鉴权
- 请求频率限制
- 操作日志审计

### 4.3 隐私保护
- 用户数据隔离
- 不存储敏感个人信息
- 支持数据导出和删除
- 符合 GDPR/个人信息保护法

---

## 5. 性能优化策略

### 5.1 缓存策略
```
┌─────────────────────────────────────────┐
│  缓存层级                                │
├─────────────────────────────────────────┤
│  L1: 内存缓存 (Node.js Map)             │
│      - 热点模板                          │
│      - 用户会话                          │
│      TTL: 5 分钟                          │
├─────────────────────────────────────────┤
│  L2: Redis 缓存                          │
│      - 生成结果（相同请求）              │
│      - 标签库                            │
│      - 用户偏好                          │
│      TTL: 1 小时 - 24 小时                 │
├─────────────────────────────────────────┤
│  L3: 数据库                              │
│      - 持久化数据                        │
└─────────────────────────────────────────┘
```

### 5.2 异步处理
- 文案生成：同步返回（< 5 秒）
- 批量生成：异步任务队列
- 数据分析：定时任务
- 文件导出：异步生成 + 通知

### 5.3 模型优化
- Prompt 压缩（减少 token 消耗）
- 流式输出（提升感知速度）
- 模型蒸馏（轻量场景）
- 本地缓存（相似请求复用）

---

## 6. 部署架构

### 6.1 开发环境
```
本地开发 → Docker Compose → 完整服务栈
```

### 6.2 生产环境
```
                    ┌─────────────┐
                    │   Nginx     │
                    │  (负载均衡)  │
                    └──────┬──────┘
                           │
           ┌───────────────┼───────────────┐
           │               │               │
    ┌──────▼──────┐ ┌──────▼──────┐ ┌──────▼──────┐
    │  App Node 1 │ │  App Node 2 │ │  App Node 3 │
    └──────┬──────┘ └──────┬──────┘ └──────┬──────┘
           │               │               │
           └───────────────┼───────────────┘
                           │
         ┌─────────────────┼─────────────────┐
         │                 │                 │
  ┌──────▼──────┐   ┌──────▼──────┐   ┌──────▼──────┐
  │  PostgreSQL │   │    Redis    │   │    MinIO    │
  │  (主从)     │   │  (哨兵)     │   │             │
  └─────────────┘   └─────────────┘   └─────────────┘
```

### 6.3 OpenClaw 技能集成
```yaml
# skill.yaml
name: 自媒体文案生成器
version: 1.0.0
description: 自媒体文案 AI 生成工具
entry: index.js
triggers:
  - pattern: "帮我写.*文案"
  - pattern: "生成.*小红书"
  - pattern: "公众号文章"
capabilities:
  - copywriting_generate
  - template_manage
  - history_query
```

---

## 7. 监控与日志

### 7.1 监控指标
- API 响应时间（P50/P95/P99）
- 模型调用成功率
- 缓存命中率
- 错误率统计
- 用户活跃度

### 7.2 日志策略
- 结构化日志（JSON 格式）
- 分级日志（DEBUG/INFO/WARN/ERROR）
- 敏感信息脱敏
- 日志保留策略（30 天）

---

*文档版本：1.0*
*创建日期：2026-03-01*
*最后更新：2026-03-01*
