# 自媒体文案生成器 - 功能设计

## 📱 支持平台

| 平台 | 特点 | 文案风格 |
|------|------|----------|
| **小红书** | 种草笔记、经验分享 | 亲切真实、emoji 丰富、分段清晰 |
| **公众号** | 深度文章、品牌宣传 | 专业严谨、逻辑完整、标题吸睛 |
| **微博** | 热点讨论、短内容 | 简洁有力、话题性强、易传播 |
| **抖音** | 视频脚本、口播文案 | 节奏感强、开头抓人、口语化 |

---

## 🎯 核心功能

### 1. 文案生成

**输入：**
- 主题/关键词（必填）
- 目标平台（必填）
- 产品/服务描述（可选）
- 目标受众（可选）
- 文案长度偏好（短/中/长）
- 语气风格（专业/幽默/温暖/激情等）

**输出：**
- 完整文案内容
- 适配平台格式的排版
- 建议配图说明（小红书/公众号）
- 建议 BGM/画面节奏（抖音）

### 2. 标题优化

**输入：**
- 原始标题
- 目标平台
- 优化方向（点击率/搜索 SEO/传播性）

**输出：**
- 5-10 个优化标题选项
- 每个标题的评分和理由
- A/B 测试建议

### 3. 标签推荐

**输入：**
- 文案内容
- 目标平台
- 期望曝光量级

**输出：**
- 热门标签（高流量）
- 精准标签（高转化）
- 长尾标签（低竞争）
- 话题标签建议（微博/抖音）

---

## 📥 输入格式

```json
{
  "platform": "xiaohongshu | wechat | weibo | douyin",
  "topic": "夏季防晒霜推荐",
  "product_desc": "SPF50+ 清爽不油腻，适合油皮",
  "target_audience": "18-30 岁女性，学生党和上班族",
  "length": "medium",
  "tone": "亲切真实",
  "keywords": ["防晒", "油皮", "夏季", "清爽"],
  "extra_requirements": "需要包含使用心得和对比"
}
```

---

## 📤 输出格式

### 小红书格式
```markdown
标题：[吸睛标题，含 emoji]

正文：
[分段内容，每段 2-3 句]
[使用 emoji 点缀]
[包含个人体验]

#标签 1 #标签 2 #标签 3

[配图建议：产品图/使用前对比/质地展示]
```

### 公众号格式
```markdown
标题：[深度标题，可含副标题]

摘要：[50-100 字内容概要]

正文：
# 引言
[痛点引入]

# 主体内容
[分章节论述]

# 结语
[总结 + 行动号召]

[排版建议：小标题/引用/加粗重点]
```

### 微博格式
```markdown
[正文内容，140 字以内]

#话题标签# #相关话题#

[配图/视频建议]
```

### 抖音格式
```markdown
【视频脚本】

0-3 秒：[黄金开头，抓住注意力]
3-15 秒：[核心内容展示]
15-30 秒：[详细说明/演示]
30-45 秒：[总结 + 行动号召]

口播文案：
[完整台词]

BGM 建议：[音乐风格]
画面建议：[镜头切换说明]

#话题 #标签
```

---

## 🔄 交互流程

```
用户输入 → 平台选择 → 参数配置 → AI 生成 → 结果展示 → 优化迭代
                                    ↓
                              多版本对比
                                    ↓
                              用户选择/修改
                                    ↓
                              最终输出
```

---

## ⚙️ 高级功能

### 批量生成
- 一次生成多平台适配版本
- 跨平台内容矩阵规划

### 热点追踪
- 实时热点关键词接入
- 趋势话题推荐

### 数据反馈
- 文案效果追踪（需接入平台 API）
- 优化建议基于历史数据

### 品牌词库
- 自定义品牌术语
- 禁用词过滤
- 风格一致性检查

---

## 🎨 用户体验设计

- **一键生成**：默认参数快速出稿
- **智能推荐**：根据历史偏好自动填充
- **实时预览**：各平台格式实时展示
- **版本管理**：保存历史生成记录
- **协作模式**：团队审核工作流

---

## 📋 功能优先级

| 优先级 | 功能 | Sprint |
|--------|------|--------|
| P0 | 基础文案生成（4 平台） | Sprint 1 |
| P0 | 标题优化 | Sprint 1 |
| P1 | 标签推荐 | Sprint 2 |
| P1 | 批量生成 | Sprint 2 |
| P2 | 热点追踪 | Sprint 3 |
| P2 | 数据反馈 | Sprint 3 |
| P3 | 品牌词库 | Sprint 3 |
