---
name: social-media-content-calendar
description: Generate structured social media content calendars with platform-specific posts, hashtags, and scheduling. Use when creating social media plans, content calendars, or social media management deliverables for clients.
argument-hint: "[niche-or-brand] [platforms] [timeframe]"
allowed-tools: Read, Write, Edit, Grep, Glob, Bash, WebSearch
---

# Social Media Content Calendar

Generate complete content calendars with platform-adapted posts, hashtag research, image prompts, and scheduling — exportable to Buffer, Hootsuite, or Later.

## How to Use

```
/social-media-content-calendar "Vegan bakery in Austin" "instagram,tiktok" "4 weeks"
/social-media-content-calendar "B2B SaaS startup" "linkedin,twitter" "2 weeks"
/social-media-content-calendar "Personal fitness coach" "instagram,youtube,tiktok" "1 month"
```

- `$ARGUMENTS[0]` = Brand/niche description
- `$ARGUMENTS[1]` = Platforms (comma-separated): `instagram`, `twitter`, `linkedin`, `tiktok`, `facebook`, `youtube`, `threads`
- `$ARGUMENTS[2]` = Timeframe (default: 4 weeks)

## Calendar Generation Process

### Step 1: Brand & Audience Analysis

From the brief, establish:
- **Brand voice**: Professional, casual, witty, inspirational, educational
- **Target audience**: Demographics, interests, pain points
- **Content pillars** (3-5 themes that all content maps to):
  - Example for fitness coach: Workouts, Nutrition, Motivation, Client Results, Behind the Scenes
- **Competitor reference**: What type of content works in this niche?

### Step 2: Platform Strategy

Set posting frequency and content types per platform:

| Platform | Posts/Week | Best Content Types | Best Times |
|----------|-----------|-------------------|------------|
| Instagram | 4-5 feed + 5-7 stories | Reels, carousels, single image | Tue-Fri 10am-2pm |
| TikTok | 5-7 | Short video (15-60s), trends | Tue-Thu 7-9pm |
| LinkedIn | 3-4 | Text posts, carousels, articles | Tue-Thu 8-10am |
| Twitter/X | 5-7 | Threads, hot takes, engagement | Mon-Fri 8-10am, 12-1pm |
| Facebook | 3-4 | Video, links, community posts | Wed-Fri 1-4pm |
| YouTube | 1-2 | Long-form, Shorts | Thu-Sat 2-4pm |
| Threads | 4-5 | Conversational, opinion, tips | Similar to Instagram |

### Step 3: Content Mix

Apply the content mix ratio:

| Content Type | Percentage | Purpose |
|-------------|-----------|---------|
| Educational | 40% | Teach, tips, how-to, tutorials |
| Engaging | 25% | Questions, polls, opinions, trends |
| Promotional | 20% | Products, services, offers, CTAs |
| Personal/BTS | 15% | Behind the scenes, story, culture |

### Step 4: Generate the Calendar

For each post, generate:

```yaml
date: "2026-02-17"
day: "Monday"
platform: "instagram"
content_type: "reel"
content_pillar: "Workouts"
mix_category: "Educational"

caption: |
  Full caption text here.

  Include line breaks for readability.

  End with a CTA (save, share, comment, link in bio).

hashtags:
  primary: ["#fitness", "#homeworkout"]  # 3-5 high-volume
  secondary: ["#fitnesstips", "#workoutmotivation"]  # 3-5 medium
  niche: ["#austinfitness", "#veganfitness"]  # 3-5 low-competition

image_prompt: "Description for AI image generation or photographer brief"
alt_text: "Accessible image description for screen readers"
cta: "Save this for your next workout"
notes: "Any additional context for the social media manager"
```

### Step 5: Platform Adaptations

Adapt EVERY post for its target platform:

**Instagram**:
- Caption: Up to 2,200 chars, but front-load first 125 chars (preview cutoff)
- Hashtags: 20-30 in first comment (not caption)
- Reels: Include hook in first 3 seconds description
- Carousels: List slide-by-slide content

**TikTok**:
- Caption: Max 300 chars
- Hashtags: 3-5 only
- Include: Hook, trending sound suggestion, video structure outline
- Focus on first 1-3 seconds hook

**LinkedIn**:
- No hashtags in body, 3-5 at the bottom
- First line is the hook (shows before "see more")
- Professional tone, data-driven
- Use line breaks aggressively (one sentence per line)

**Twitter/X**:
- 280 chars max per tweet
- Threads: Number each tweet, hook in tweet 1
- No hashtags in body (1-2 max if any)
- Engagement hooks: questions, polls, hot takes

**Facebook**:
- Longer posts OK (1-2 paragraphs)
- Questions drive comments
- Link posts: compelling description above the link
- 1-3 hashtags max

### Step 6: Output Format

Generate files in `output/content-calendar/`:

```
output/content-calendar/
  calendar-overview.md          # Strategy summary, pillars, mix ratios
  week-1.md                     # All posts for week 1
  week-2.md                     # All posts for week 2
  ...
  calendar-export.csv           # Import-ready for Buffer/Hootsuite/Later
  hashtag-library.md            # All researched hashtags by category
  image-prompts.md              # All image/video descriptions consolidated
```

**CSV Export Format** (Buffer/Hootsuite compatible):
```csv
Date,Time,Platform,Content,Hashtags,Image Description,Link
2026-02-17,10:00,instagram,"Caption text here","#tag1 #tag2","Image description",""
```

### Step 7: Hashtag Research

For the niche, build a hashtag library:

```markdown
## Hashtag Library: [Niche]

### High Volume (500K+ posts) — Use 3-5 per post
#fitness #workout #healthylifestyle ...

### Medium Volume (50K-500K) — Use 3-5 per post
#fitnesstips #homeworkoutroutine ...

### Low Competition / Niche (under 50K) — Use 3-5 per post
#austinfitcoach #veganathlete ...

### Branded (create for client)
#[brandname] #[brandname]tips #[brandname]community

### Trending (rotate weekly)
[Research current trending hashtags in niche]
```

## Quality Checks

- [ ] Every post has platform-appropriate character count
- [ ] Content mix follows the 40/25/20/15 ratio across the calendar
- [ ] All content pillars are represented each week
- [ ] No two consecutive posts are the same content type
- [ ] Hashtags are varied (not the same set every post)
- [ ] Every post has a CTA
- [ ] Weekend posts are lighter/more personal
- [ ] CSV export is properly formatted for import
- [ ] Image prompts are specific enough to produce consistent visuals
