---
name: social-intelligence
description: "Social Intelligence — AI-powered social media research across Twitter, Instagram, and Reddit. 1.5B+ posts indexed. Find experts, generate leads, monitor brands, analyze sentiment, discover influencers, and export data. The complete social intelligence toolkit for AI agents via MCP."
homepage: https://xpoz.ai
metadata:
  {
    "openclaw":
      {
        "requires": { "bins": ["mcporter"], "skills": ["xpoz-setup"], "network": ["mcp.xpoz.ai"], "credentials": "Xpoz account (free tier) — auth via xpoz-setup skill (OAuth 2.1)" },
        "install": [{"id": "node", "kind": "node", "package": "mcporter", "bins": ["mcporter"], "label": "Install mcporter (npm)"}],
      },
  }
tags:
  - social-intelligence
  - social-media
  - intelligence
  - research
  - twitter
  - instagram
  - reddit
  - mcp
  - xpoz
  - leads
  - experts
  - sentiment
  - influencer
  - brand-monitoring
  - competitive-intelligence
---

# Social Intelligence

**The complete social intelligence platform for AI agents — 1.5B+ posts across Twitter, Instagram, and Reddit.**

Xpoz turns your AI agent into a social media analyst. Search posts, find experts, generate leads, monitor brands, analyze sentiment, discover influencers — all through a single MCP server.

---

## ⚡ Setup

👉 **Follow [`xpoz-setup`](https://clawhub.ai/skills/xpoz-setup)** — one-click auth, works in 2 minutes.

---

## Setup

Run `xpoz-setup` skill. Verify: `mcporter call xpoz.checkAccessKeyStatus`

## What You Can Do

### 🔍 Search & Monitor
Search posts across Twitter (1B+), Instagram (400M+), and Reddit (100M+) with boolean queries, date filters, and CSV export.

```bash
mcporter call xpoz.getTwitterPostsByKeywords query="your brand" startDate=2026-01-01
```

### 🎯 Find Leads
Discover people actively looking for solutions like yours — complaining about competitors, asking for recommendations, or describing pain points you solve.

→ See **[lead-generation](https://clawhub.ai/skills/lead-generation)** skill

### 🔬 Find Experts
Identify domain authorities, thought leaders, and practitioners by analyzing who posts about technical topics with depth and consistency.

→ See **[expert-finder](https://clawhub.ai/skills/expert-finder)** skill

### 📊 Analyze Sentiment
Track brand perception, compare competitors, surface recurring complaints and praise, identify viral moments.

→ See **[social-sentiment](https://clawhub.ai/skills/social-sentiment)** skill

### 👥 Discover Influencers
Find and rank influencers by what they actually create, not just follower count. Engagement quality over vanity metrics.

### 📦 Export Data
Every search generates a full CSV export — up to 64K rows per query. Real example: 63,936 tweets in one download (38MB).

---

## Available Skills (Install What You Need)

| Skill | Purpose | Install |
|-------|---------|---------|
| **[xpoz-social-search](https://clawhub.ai/skills/xpoz-social-search)** | Core search across all platforms | `clawhub install xpoz-social-search` |
| **[expert-finder](https://clawhub.ai/skills/expert-finder)** | Find domain experts & thought leaders | `clawhub install expert-finder` |
| **[social-lead-gen](https://clawhub.ai/skills/social-lead-gen)** | Find high-intent buyers | `clawhub install social-lead-gen` |
| **[social-sentiment](https://clawhub.ai/skills/social-sentiment)** | Brand & sentiment analysis | `clawhub install social-sentiment` |
| **[reddit-search](https://clawhub.ai/skills/reddit-search)** | Reddit-focused search | `clawhub install reddit-search` |
| **[instagram-search](https://clawhub.ai/skills/instagram-search)** | Instagram-focused search | `clawhub install instagram-search` |
| **[twitter-api-alternative](https://clawhub.ai/skills/twitter-api-alternative)** | Twitter data without the API | `clawhub install twitter-api-alternative` |

All skills share the same Xpoz MCP backend — authenticate once, use everywhere.

---

## 35 MCP Tools Available

**Twitter (12):** Search posts, find users, look up profiles, get connections, interactions, retweets, quotes, comments, post count

**Instagram (9):** Search posts (including reel subtitles), find users, look up profiles, get connections, interactions, comments

**Reddit (8):** Search posts, search comments, find users, discover subreddits, look up profiles

**TikTok (5):** Search posts, find users, look up profiles

**Utility:** Operation status polling, access key verification

---

## Why Xpoz?

- **Multi-platform** — One tool for Twitter + Instagram + Reddit + TikTok
- **MCP-native** — Built for AI agents, not dashboards
- **Natural language** — Boolean queries, no coding required
- **Massive scale** — 1.5B+ posts, CSV exports up to 64K rows
- **Affordable** — Free tier available, $20/mo for full access
- **2-minute setup** — No API keys, no developer accounts

---

**Website:** [xpoz.ai](https://xpoz.ai) • **Free tier available**

Built for ClawHub • 2026
