# Resort Slugs & SnowTick Codes

OpenSnow URL pattern: `https://opensnow.com/location/{slug}/snow-summary`

**SnowTick** — 4-letter codes for quick mountain lookups, like stock tickers.

## Wyoming / Tetons
| Resort | Ticker | Slug |
|--------|--------|------|
| Jackson Hole | `JHMR` | `jacksonhole` |
| Grand Targhee | `TARG` | `grandtarghee` |
| Snow King | `SNWK` | `snowking` |

## California — Tahoe
| Resort | Ticker | Slug |
|--------|--------|------|
| Palisades Tahoe | `PALI` | `squawalpine` |
| Heavenly | `HVLY` | `heavenly` |
| Kirkwood | `KIRK` | `kirkwood` |
| Northstar | `NSTR` | `northstar` |
| Sugar Bowl | `SGAR` | `sugarbowl` |
| Mt. Rose | `ROSE` | `mtrose` |
| Diamond Peak | `DIAM` | `diamondpeak` |
| Homewood | `HOME` | `homewood` |
| Sierra-at-Tahoe | `SIER` | `sierra` |

## California — Mammoth / Eastern Sierra
| Resort | Ticker | Slug |
|--------|--------|------|
| Mammoth Mountain | `MMTH` | `mammoth` |
| June Mountain | `JUNE` | `june` |

## California — SoCal
| Resort | Ticker | Slug |
|--------|--------|------|
| Big Bear Mountain | `BEAR` | `bigbear` |
| Mountain High | `MTHI` | `mountainhigh` |
| Snow Summit | `SSUM` | `snowsummit` |
| Snow Valley | `SVAL` | `snowvalley` |

## Utah — Cottonwood Canyons
| Resort | Ticker | Slug |
|--------|--------|------|
| Alta | `ALTA` | `alta` |
| Snowbird | `BIRD` | `snowbird` |
| Brighton | `BRIT` | `brighton` |
| Solitude | `SOLI` | `solitude` |

## Utah — Park City Area
| Resort | Ticker | Slug |
|--------|--------|------|
| Park City | `PCMR` | `parkcity` |
| Deer Valley | `DEER` | `deervalley` |

## Colorado — I-70 Corridor
| Resort | Ticker | Slug |
|--------|--------|------|
| Vail | `VAIL` | `vail` |
| Beaver Creek | `BVRC` | `beavercreek` |
| Breckenridge | `BREC` | `breckenridge` |
| Keystone | `KEYS` | `keystone` |
| Copper Mountain | `COPR` | `copper` |
| Arapahoe Basin | `ABAY` | `abasin` |
| Loveland | `LOVE` | `loveland` |
| Winter Park | `WNTR` | `winterpark` |
| Eldora | `ELDO` | `eldora` |

## Colorado — Aspen / Roaring Fork
| Resort | Ticker | Slug |
|--------|--------|------|
| Aspen Mountain | `AJAX` | `aspen` |
| Aspen Highlands | `HIGH` | `aspenhighlands` |
| Snowmass | `MASS` | `snowmass` |
| Buttermilk | `BUTM` | `buttermilk` |

## Colorado — Southern
| Resort | Ticker | Slug |
|--------|--------|------|
| Telluride | `TELL` | `telluride` |
| Crested Butte | `CBUT` | `crestedbutte` |
| Wolf Creek | `WOLF` | `wolfcreek` |
| Monarch | `MNCH` | `monarch` |
| Purgatory | `PURG` | `purgatory` |

## Colorado — Steamboat / Northern
| Resort | Ticker | Slug |
|--------|--------|------|
| Steamboat | `BOAT` | `steamboat` |
| Howelsen Hill | `HOWL` | `howelsen` |

## Montana
| Resort | Ticker | Slug |
|--------|--------|------|
| Big Sky | `BSKY` | `bigsky` |
| Whitefish | `FISH` | `whitefish` |
| Bridger Bowl | `BRDG` | `bridgerbowl` |
| Great Divide (Belrock) | `ROCK` | `greatdivide` |
| Discovery | `DISC` | `discovery` |
| Red Lodge | `REDL` | `redlodge` |

## Idaho
| Resort | Ticker | Slug |
|--------|--------|------|
| Sun Valley | `SUNV` | `sunvalley` |
| Tamarack | `TAMR` | `tamarack` |
| Schweitzer | `SCHW` | `schweitzer` |
| Bogus Basin | `BOGU` | `bogusbasin` |
| Brundage | `BRUN` | `brundage` |

## Pacific Northwest
| Resort | Ticker | Slug |
|--------|--------|------|
| Crystal Mountain | `CRYS` | `crystalwa` |
| Stevens Pass | `STEV` | `stevenspass` |
| Mt. Baker | `BAKR` | `mtbaker` |
| Mt. Hood Meadows | `HOOD` | `meadows` |
| Timberline | `TMBR` | `timberline` |
| Mt. Bachelor | `BACH` | `bachelor` |

## Alaska
| Resort | Ticker | Slug |
|--------|--------|------|
| Tordrillo Mountain Lodge | `TORD` | `tordrillomountainlodge` |
| Alyeska | `ALYS` | `alyeska` |

## British Columbia
| Resort | Ticker | Slug |
|--------|--------|------|
| Whistler Blackcomb | `WHIS` | `whistler` |
| Revelstoke | `RVLK` | `revelstoke` |
| Kicking Horse | `KICK` | `kickinghorse` |
| Fernie | `FERN` | `fernie` |
| Red Mountain | `REDM` | `red` |
| Baldface Lodge | `BALD` | `cabaldface` |

## Alberta
| Resort | Ticker | Slug |
|--------|--------|------|
| Lake Louise | `LLOU` | `lakelouise` |
| Sunshine Village | `SUNS` | `sunshinevillage` |
| Banff Norquay | `NORQ` | `banffnorquay` |

## New England
| Resort | Ticker | Slug |
|--------|--------|------|
| Killington | `KILL` | `killington` |
| Stowe | `STOW` | `stowe` |
| Sugarbush | `BUSH` | `sugarbush` |
| Jay Peak | `JAYX` | `jaypeak` |
| Sunday River | `SRIV` | `sundayriver` |
| Sugarloaf | `LOAF` | `sugarloaf` |

## Japan
| Resort | Ticker | Slug |
|--------|--------|------|
| Niseko | `NSKO` | `niseko` |
| Hakuba | `HAKU` | `hakuba` |
| Nozawa Onsen | `NOZW` | `nozawa` |
| Myoko Kogen | `MYKO` | `myoko` |
| Rusutsu | `RUSU` | `rusutsu` |

## Europe — Alps
| Resort | Ticker | Slug |
|--------|--------|------|
| Chamonix | `CHAM` | `chamonix` |
| Val d'Isère | `VALD` | `valdisere` |
| Verbier | `VERB` | `verbier` |
| Zermatt | `ZERM` | `zermatt` |
| St. Anton | `ANTO` | `stanton` |

---

## Ticker Guidelines

When adding new resorts, create tickers that are:
- **4 characters** (uppercase)
- **Intuitive** — recognizable to skiers
- **Unique** — no collisions
- **Memorable** — nickname vibes over abbreviations

Good: `BIRD` (Snowbird), `BOAT` (Steamboat), `AJAX` (Aspen Mountain's local name)
Avoid: `SNBD`, `STBT`, `ASPM`
