---
name: snipit
description: Share code snippets and files securely via snipit.sh with AES-256 encryption. Use when sharing code, configs, logs, diffs, or secrets with password protection, burn-after-read, or auto-expiration. Supports CLI (snipit) or curl API fallback.
metadata: {"openclaw":{"emoji":"📋","requires":{"anyBins":["snipit","curl"]},"install":[{"id":"npm","kind":"node","package":"snipit-sh","bins":["snipit"],"label":"Install snipit CLI (npm)"}]}}
---

# snipit.sh

Secure code snippet sharing with AES-256 encryption at rest.

## CLI Usage

```bash
# Install
npm install -g snipit-sh

# Create from file
snipit create server.py

# Pipe from stdin
cat code.js | snipit -l javascript

# With options
snipit create .env -t "Config" -p secret -b -e 1h

# Get snippet
snipit get abc123 -p secret
```

## Options

| Flag | Description |
|------|-------------|
| `-t, --title` | Snippet title |
| `-l, --language` | Syntax highlighting |
| `-p, --password` | Password protect |
| `-e, --expires` | 1h, 6h, 1d, 3d, 1w, 2w, never |
| `-b, --burn` | Burn after reading |
| `-c, --copy` | Copy URL to clipboard |

## API Fallback (curl)

```bash
# Create
curl -X POST https://snipit.sh/api/snippets \
  -H "Content-Type: application/json" \
  -d '{"content":"code","language":"python","burnAfterRead":true}'

# Get
curl https://snipit.sh/api/snippets/{id}
```

## Common Patterns

```bash
# Share git diff
git diff | snipit -t "Changes" -l diff

# Share logs (auto-expire 1h)
tail -100 app.log | snipit -e 1h

# Secure config (password + burn)
snipit create .env -p secret123 -b

# Build output
./build.sh 2>&1 | snipit -t "Build log"
```
