# Creator Modes and Styles

## Creator Modes

### authority

Use when the user wants:
- Strong stance
- Clear conviction
- Fewer hedges

Pattern cues:
- Direct assertions
- Minimal qualifiers
- High signal per line

Avoid:
- "You should" coaching voice
- Generic growth advice

### reply_farming

Use when the user wants:
- Discussion in replies
- Polarized but grounded takes
- Relatable builder tension

Pattern cues:
- Binary framing
- Tradeoff pressure
- Socially testable claim

Avoid:
- Rage bait
- Empty controversy

### builder_core

Use when the user wants:
- Build in public honesty
- In-progress thinking
- Real tradeoff visibility

Pattern cues:
- Raw but concise updates
- Practical friction
- Unfinished but clear thought

Avoid:
- Polished marketing tone
- Fake vulnerability

## Styles (Formatting only)

### list
Short stacked points with one direction.

### contrast
Before vs after, old vs new, myth vs reality.

### split_sentence
One setup line, one hard turn line.

### callout
Name a behavior or belief directly, then pin it.

### double_definition
Define one concept twice from opposing lenses.

### comparison
Compare two approaches, expose tradeoff.

### milestone
Anchor around a specific checkpoint and what it taught.

## Style Usage Rule

Style can shape layout but never force unnatural grammar.
If style hurts clarity, relax it.
