---
name: snapog
description: Generate social images and OG cards from professional templates via the SnapOG API. One API call = one pixel-perfect PNG.
homepage: https://snapog.dev
metadata: {"openclaw":{"emoji":"⚡","primaryEnv":"SNAPOG_API_KEY","requires":{"env":["SNAPOG_API_KEY"]}}}
---

# SnapOG — Social Image Generation

Generate OG images, social cards, and marketing visuals from professionally designed templates. Returns pixel-perfect PNGs in under 100ms.

**API Base:** `https://api.snapog.dev`

## Authentication

All generation requests require a Bearer token. The API key is read from the `SNAPOG_API_KEY` environment variable.

```
Authorization: Bearer $SNAPOG_API_KEY
```

Preview and template listing endpoints work without authentication.

## Available Templates

| Template | ID | Best For |
|----------|----|----------|
| Blog Post | `blog-post` | Blog articles, tutorials, documentation |
| Announcement | `announcement` | Product launches, updates, releases |
| Stats Card | `stats` | Metrics dashboards, quarterly results |
| Quote | `quote` | Testimonials, pull quotes, social shares |
| Product Card | `product` | SaaS products, pricing, features |
| GitHub Repo | `github-repo` | Open source projects, repo cards |
| Event | `event` | Conferences, meetups, webinars |
| Changelog | `changelog` | Release notes, version updates |
| Brand Card | `brand-card` | Company pages, docs, marketing |
| Photo Hero | `photo-hero` | Blog headers, news, portfolios |

## Core Workflows

### 1. List templates and discover parameters

```bash
curl https://api.snapog.dev/v1/templates
```

Returns all templates with their `paramSchema` (parameter names, types, required fields, defaults). Always call this first if the user hasn't specified a template.

### 2. Generate an image (POST)

Use this for downloading images or advanced options:

```bash
curl -X POST https://api.snapog.dev/v1/generate \
  -H "Authorization: Bearer $SNAPOG_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{
    "template": "blog-post",
    "params": {
      "title": "Building with MCP",
      "author": "Taylor",
      "tags": ["AI", "Tools"],
      "accentColor": "#6366f1"
    }
  }' \
  --output og-image.png
```

**POST body fields:**
- `template` (string, required) — template ID
- `params` (object, required) — template parameters
- `width` (number) — image width in pixels (default: 1200)
- `height` (number) — image height in pixels (default: 630)
- `format` ("png" | "svg" | "pdf") — output format (default: png)
- `fontFamily` (string) — any Google Font family name
- `webhook_url` (string) — URL to POST when generation completes

Save the response body directly to a `.png` file. The response Content-Type is `image/png`.

### 3. Generate via URL (GET)

Use this when the user needs a URL to embed in HTML meta tags, markdown, or anywhere an image URL is needed:

```
https://api.snapog.dev/v1/og/blog-post?title=Building+with+MCP&author=Taylor&tags=AI,Tools
```

This URL itself serves the image. Parameters are query strings. Requires `Authorization` header or a signed URL.

### 4. Preview a template (no auth needed)

```bash
curl https://api.snapog.dev/v1/preview/blog-post --output preview.png
```

Renders the template with its default parameters. Useful for showing the user what a template looks like before customizing.

### 5. Create a signed URL (for meta tags)

Signed URLs let you embed images in `<meta>` tags without exposing the API key:

```bash
curl -X POST https://api.snapog.dev/v1/sign \
  -H "Authorization: Bearer $SNAPOG_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{
    "template": "blog-post",
    "params": { "title": "My Post" },
    "expiresIn": 86400
  }'
```

Returns `{ "url": "https://api.snapog.dev/v1/og/blog-post?title=...&token=..." }`. This URL works without authentication and can be placed directly in HTML:

```html
<meta property="og:image" content="SIGNED_URL_HERE" />
```

### 6. Batch generate (multiple sizes)

Generate the same image in multiple sizes at once:

```bash
curl -X POST https://api.snapog.dev/v1/batch \
  -H "Authorization: Bearer $SNAPOG_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{
    "template": "blog-post",
    "params": { "title": "My Post" },
    "sizes": ["og", "twitter", "farcaster", "instagram-square"]
  }'
```

**Size presets:** `og` (1200x630), `twitter` (1200x628), `farcaster` (1200x800), `instagram-square` (1080x1080), `instagram-story` (1080x1920), `linkedin` (1200x627), `facebook` (1200x630), `pinterest` (1000x1500).

## Common Parameters

Most templates accept these shared parameters:

- `title` (string, required) — main heading
- `accentColor` (color) — theme color, e.g. `#6366f1`
- `logo` (url) — logo image URL
- `fontFamily` (string) — any Google Font, e.g. `"Space Grotesk"`

Each template has additional specific parameters. Call `/v1/templates` to see the full schema for any template.

## Tips

- **Choosing a template:** Match the content type — `blog-post` for articles, `announcement` for launches, `github-repo` for OSS projects, `stats` for metrics, `quote` for testimonials.
- **Colors:** Pass hex colors like `#6366f1`. Most templates support `accentColor` for theming.
- **Arrays:** For `tags` and `changes`, pass as JSON arrays: `["tag1", "tag2"]`.
- **Stats:** The `stats` template expects a JSON array: `[{"label": "Users", "value": "10K"}]`.
- **Images:** For `logo`, `image`, `authorImage` — pass a publicly accessible URL.
- **Output:** Default is 1200x630 PNG (standard OG image size). Use `width`/`height` to customize.
- **Formats:** Use `"svg"` for vector output, `"pdf"` for print-ready documents.

## Full API Docs

For the complete API reference as markdown (useful for deeper integration):

```bash
curl https://api.snapog.dev/v1/docs
```
