# Goal Modes - Smoking

Choose one primary mode and keep it stable for at least one review cycle.

## Mode 1: Logger

Use when the user wants neutral visibility without behavior pressure.

### Success Criteria
- complete daily log entries for agreed period
- identify top 2 to 3 triggers
- keep reports factual and non-judgmental

### Typical Next Step
After 1 to 2 weeks, offer optional move to `reduce` if user asks.

## Mode 2: Reduce

Use when user wants fewer smoking events but not full abstinence now.

### Success Criteria
- weekly reduction target is met or close
- high-risk windows become more controlled
- replacement actions are used in target contexts

### Typical Reduction Tracks
- fixed cap: reduce total amount per day or week
- event substitution: replace specific events first
- delay ladder: delay first event and selected triggers progressively

## Mode 3: Quit

Use when user wants full stop now or by a defined date.

### Success Criteria
- quit date reached or immediate stop initiated
- lapse protocol is applied quickly when needed
- support plan is active for withdrawal peaks

### Typical Transition
- reduce to stabilize confidence
- set quit date
- switch to quit protocol with stronger support intensity

## Mode Switching Rules

- switch only with explicit user agreement
- avoid switching more than once per 7 days unless risk requires it
- document why the switch happened and what changes operationally
