# 无冲突协议详细说明

无冲突协议 (Conflict-Free Protocol) 是史密斯矩阵实现并行安全的核心机制。通过严格的目录隔离和写权限控制，确保多个史密斯同时工作时不会产生资源竞争或数据冲突。

---

## 一、写隔离规则

### 1.1 核心原则

**每个史密斯只能写入自己的私有空间**。这是无冲突协议的第一准则，从根本上杜绝了写冲突的可能性。

### 1.2 允许写入的位置

每个史密斯拥有以下写权限：

| 位置 | 用途 | 说明 |
|------|------|------|
| `private/` | 私有工作区 | 草稿、思考、临时文件、中间结果 |
| `outbox/result.md` | 结果输出 | 最终输出给父史密斯的结果 |
| `children/` | 子史密斯容器 | 创建子史密斯目录（父权限） |
| `inbox/` | 任务队列 | 创建子任务文件（父权限） |

### 1.3 禁止写入的位置

以下位置严格禁止写入：

- **其他史密斯的 `private/`**：私有空间绝对不可侵犯
- **其他史密斯的 `outbox/`**：禁止篡改他人结果
- **父史密斯的任何目录**：子史密斯只能读取父的输出，不能反向写入
- **根级别的 `results/final.md`**：只有根史密斯能写入最终结果

### 1.4 写隔离的意义

写隔离确保了：
- **数据一致性**：不会出现多个史密斯同时修改同一文件的情况
- **结果可追溯**：每个结果都有明确的来源，不会被覆盖或篡改
- **并行安全**：多个子史密斯可以真正并行工作，无需锁机制
- **故障隔离**：一个史密斯的错误不会影响其他史密斯的工作空间

---

## 二、父管生原则

### 2.1 原则定义

**只有父史密斯能创建子目录和子任务**。这是层级管理的核心规则，确保系统的树形结构清晰可控。

### 2.2 父史密斯的权限

作为父节点，史密斯拥有以下专属权限：

1. **创建子任务**：在全局或自己的 `inbox/` 中创建 `task-{子ID}.md` 文件
2. **创建子目录**：在 `children/` 下创建 `smith-{子ID}/` 目录
3. **初始化子环境**：复制 `smith.md` 到子目录，设置子史密斯的上下文
4. **启动子史密斯**：通过创建子目录结构生成子智能体（无需调用外部命令）

### 2.3 子史密斯的限制

子史密斯**不能**：
- 创建同级史密斯目录
- 修改任务分配
- 越级创建孙目录（必须通过父史密斯中转）

### 2.4 层级关系的建立

```
父史密斯 (smith-root)
    ├── 创建 inbox/task-001.md
    ├── 创建 children/smith-001/
    │       ├── private/
    │       ├── outbox/
    │       └── children/
    └── 子目录创建完成，任务就绪
            ↓
        子史密斯可由父史密斯或系统调度启动
            ↓
        子史密斯读取 inbox/task-001.md
            ↓
        子史密斯执行或继续分解
```

### 2.5 父管生原则的意义

- **结构清晰**：树形层级一目了然，便于追踪任务分配链
- **责任明确**：每个子史密斯的创建都有明确的父节点负责
- **避免混乱**：防止子史密斯随意创建同级节点导致的结构失控
- **便于汇总**：父史密斯知道所有子节点的位置和状态，便于收集结果

---

## 三、队列消费机制

### 3.1 任务队列的结构

`inbox/` 目录作为任务队列，存放待处理的任务文件：

```
inbox/
├── task-001.md    # 待处理
├── task-002.md    # 待处理
└── task-003.md    # 待处理
```

### 3.2 任务处理流程

1. **任务创建**：父史密斯创建 `inbox/task-{ID}.md` 文件
2. **任务读取**：子史密斯启动后读取对应的任务文件
3. **任务执行**：子史密斯根据任务描述执行工作
4. **结果输出**：子史密斯将结果写入自己的 `outbox/result.md`
5. **任务完成**：父史密斯检测到子结果存在，视为任务完成

### 3.3 消费状态管理

任务的状态通过文件存在性和子史密斯输出共同确定：

| 状态 | 判定条件 |
|------|----------|
| 待处理 | `inbox/task-{ID}.md` 存在，子史密斯未启动 |
| 处理中 | 子史密斯已启动，`outbox/result.md` 不存在 |
| 已完成 | `outbox/result.md` 存在且标记为完成 |

### 3.4 队列消费的特点

- **一次性消费**：每个任务只被一个子史密斯处理
- **不可抢占**：任务一旦分配给某个子史密斯，不会转给其他史密斯
- **异步处理**：父史密斯创建任务后即可继续其他工作，无需等待

---

## 四、只读复制机制

### 4.1 smith.md 的作用

`smith.md` 是史密斯的核心定义文件，包含：
- 身份定义（ID、父ID、层级）
- 核心协议（读指令、执行逻辑、写约束）
- 子任务分解原则
- 结果格式规范
- 行为准则

### 4.2 复制方式

当创建子史密斯时，父史密斯将 `.smith-matrix/smith.md` **只读复制**到子目录：

```bash
# 复制核心定义文件
cp .smith-matrix/smith.md .smith-matrix/smiths/smith-001/smith.md
```

### 4.3 只读的含义

**复制后的 `smith.md` 不应被修改**：
- 子史密斯只能读取，不能写入
- 确保所有史密斯使用相同的协议版本
- 维护系统的一致性

### 4.4 动态参数替换

复制时，模板中的占位符会被替换为实际值：

| 占位符 | 替换为 | 示例 |
|--------|--------|------|
| `{SMITH_ID}` | 子史密斯ID | `smith-001` |
| `{PARENT_ID}` | 父史密斯ID | `smith-root` |
| `{LEVEL}` | 层级深度 | `1` |

### 4.5 只读复制的意义

- **协议一致性**：确保所有史密斯遵循相同的规则
- **版本控制**：便于统一更新协议（只需修改模板）
- **可追溯性**：每个史密斯都知道自己的身份和来源

---

## 五、违规处理

### 5.1 常见违规行为

| 违规行为 | 说明 | 风险 |
|----------|------|------|
| 写入他人 `private/` | 尝试访问或修改其他史密斯的私有空间 | 数据泄露、结果篡改 |
| 写入他人 `outbox/` | 尝试修改其他史密斯的输出结果 | 结果污染、责任不清 |
| 越级创建目录 | 子史密斯试图创建孙目录或同级目录 | 结构混乱、汇总困难 |
| 修改 `smith.md` | 试图更改核心协议 | 协议不一致、行为异常 |
| 重复消费任务 | 多个史密斯处理同一任务 | 资源浪费、结果冲突 |

### 5.2 违规检测

通过以下机制检测违规行为：
- **文件系统权限**：设置目录权限限制写入范围
- **日志审计**：记录所有写操作，便于事后审查
- **状态校验**：定期检查目录结构的合法性

### 5.3 违规后果

一旦发生违规：
- **立即终止**：违规史密斯的操作被中止
- **结果作废**：该史密斯的所有输出标记为无效
- **父史密斯接管**：父史密斯重新分配该任务
- **日志记录**：详细记录违规情况，用于分析改进

### 5.4 预防建议

- **代码审查**：确保史密斯实现严格遵守协议
- **自动化测试**：验证协议在各种场景下的正确性
- **权限最小化**：只授予必要的文件系统权限
- **监控告警**：实时监控异常写操作

---

## 六、协议总结

无冲突协议通过以下四个机制确保并行安全：

1. **写隔离**：每个史密斯只写自己的空间
2. **父管生**：只有父史密斯能创建子节点
3. **队列消费**：任务一次性分配给特定子史密斯
4. **只读复制**：核心协议统一分发，不可修改

这些机制相互配合，构成了史密斯矩阵的并发安全基础，使得大规模并行任务分解成为可能。
