# 史密斯矩阵核心概念详解

## 一、史密斯的定义和特性

### 1.1 什么是史密斯

**史密斯 (Smith)** 是史密斯矩阵中的基本智能体单元，是一个递归自相似的多智能体节点。每个史密斯都是一个完整的、能够独立工作的 AI 实体，具有唯一的标识符（如 `smith-root`、`smith-001`）和明确的层级关系。

史密斯的命名灵感来源于《黑客帝国》中的特工史密斯——能够自我复制、分布式的存在。在矩阵系统中，每个史密斯都遵循相同的核心协议，具备一致的行为模式。

### 1.2 自相似特性

自相似是史密斯矩阵的核心设计哲学，体现在以下方面：

**结构自相似**：每个史密斯拥有相同的目录结构（`private/`、`outbox/`、`children/`），无论层级深浅，结构保持一致。

**行为自相似**：所有史密斯使用完全相同的协议和决策逻辑。根史密斯分解任务的策略，与子史密斯分解子任务的策略完全一致。

**协议自相似**：读写规则、通信机制、结果格式在所有层级统一适用。

这种自相似性使得系统具有极强的可扩展性和可预测性——理解一个史密斯，就等于理解了整个矩阵。

### 1.3 史密斯的四大能力

每个史密斯可以执行以下操作：

1. **执行任务**：独立完成任务，将结果输出到 `outbox/result.md`
2. **分解任务**：分析任务复杂度，决定是否需要分解为子任务
3. **创建子史密斯**：为子任务创建子目录和子任务文件，完成子史密斯的初始化（限制：最大层级3，每层最多5个子史密斯）
4. **汇总结果**：收集子史密斯的输出，整合为统一结果上报

---

## 二、目录隔离机制详解

目录隔离是史密斯矩阵实现无冲突并行的基础。每个史密斯拥有独立的工作空间，通过严格的写权限控制避免资源竞争。

### 2.1 private/ —— 私有工作区

**作用**：史密斯的私人空间，用于存储思考过程、草稿、临时文件、中间结果。

**特点**：
- 完全私有，其他史密斯不可见
- 可以任意写入，无需担心冲突
- 适合记录决策过程、尝试性方案、调试信息

**使用场景**：
- 任务分析笔记
- 分解策略草稿
- 中间计算结果
- 调试日志

### 2.2 outbox/ —— 结果输出区

**作用**：存放史密斯的最终输出结果，供父史密斯读取。

**特点**：
- 只能写入自己的 `outbox/`，禁止写入其他史密斯的 `outbox/`
- 标准输出文件为 `outbox/result.md`
- 格式统一，便于父史密斯汇总

**标准结构**：
```markdown
# 结果: {任务标题}

## 摘要
一句话总结。

## 详细结果
...

## 子任务引用 (如有)
- 子史密斯 smith-xxx 处理: ...

## 完成状态
- [x] 已完成
- 完成时间: {时间戳}
```

### 2.3 inbox/ —— 任务队列

**作用**：存放待处理的任务，是父史密斯向子史密斯分配工作的唯一通道。

**特点**：
- **父写子读**：只有父史密斯能创建任务文件，子史密斯只能读取
- 任务文件命名规范：`task-{任务ID}.md`
- 任务被读取后即视为"处理中"

**任务文件结构**：
```markdown
# 任务: {任务标题}

## 描述
{任务详细描述}

## 输入
{所需输入数据}

## 期望输出
{期望的结果格式和内容}

## 父上下文
{父史密斯提供的背景信息}
```

### 2.4 children/ —— 子史密斯容器

**作用**：存放子史密斯的完整目录结构。

**特点**：
- **父管生原则**：只有父史密斯能创建子目录
- 每个子目录是一个完整的史密斯环境
- 子目录内部同样包含 `private/`、`outbox/`、`children/`

**创建流程**：
1. 父史密斯在 `inbox/` 创建子任务文件
2. 父史密斯在 `children/` 创建子史密斯目录
3. 父史密斯完成子目录创建，子史密斯就绪（最大层级3，层级≥3时禁止分解）
4. 子史密斯读取任务，开始执行

---

## 三、递归分解策略

### 3.1 何时分解

史密斯在以下情况下应该分解任务：

**需要不同领域知识**：任务涉及多个专业领域，单一史密斯难以全面掌握。例如："开发一个电商网站"需要前端、后端、数据库、UI设计等不同领域的知识。

**可以并行处理**：子任务之间相互独立，可以同时进行。例如："调研三个竞品"可以分解为三个独立的调研任务。

**复杂度超过3个主要步骤**：如果完成任务需要超过3个主要步骤，分解可以提高效率和质量。例如："撰写技术文档"可能需要大纲设计、内容编写、代码示例、审核修订等多个步骤。

### 3.2 如何分解

分解任务时遵循以下原则：

**独立性原则**：每个子任务应该尽可能独立，减少子史密斯之间的依赖和通信需求。

**明确边界**：为每个子任务定义清晰的输入和输出，避免范围模糊导致的重复或遗漏。

**粒度适中**：子任务的复杂度应与父任务相当或更低，避免"头重脚轻"的分解。

**并行友好**：设计子任务时考虑并行执行的可能性，最大化利用多智能体的优势。

### 3.3 分解流程

```
分析任务
    ↓
判断是否需要分解
    ↓
是 → 设计子任务（确定数量、定义边界、分配ID）
    ↓
创建 inbox/task-{子ID}.md 文件
    ↓
创建 children/smith-{子ID}/ 目录
    ↓
完成子目录创建，子史密斯就绪（限制：每层最多5个子史密斯，最大层级3）
    ↓
等待子结果（轮询子目录 outbox/）
    ↓
汇总结果 → 写入 outbox/result.md
```

---

## 四、结果汇总流程

### 4.1 汇总时机

当满足以下条件时，父史密斯开始汇总：
- 所有子史密斯的 `outbox/result.md` 都已存在
- 子结果标记为"已完成"
- 没有进行中的子任务

### 4.2 汇总策略

**简单汇总**：直接合并子结果，适用于独立子任务的场景。

**结构化汇总**：按特定结构组织子结果，例如按时间线、按模块、按重要性排序。

**综合分析**：不仅合并，还要进行交叉分析、对比、提炼共性结论。

### 4.3 汇总步骤

1. **读取所有子结果**：遍历 `children/` 目录，读取每个子史密斯的 `outbox/result.md`
2. **验证完整性**：检查是否所有子任务都已完成，结果是否符合预期
3. **整合内容**：根据任务性质选择合适的汇总策略
4. **生成摘要**：提炼一句话总结，便于上级快速理解
5. **记录引用**：在结果中注明各子史密斯的贡献，保持可追溯性
6. **输出到 outbox/**：按照标准格式写入 `outbox/result.md`

### 4.4 终止条件

每个史密斯必须确保任务有明确的终点：

- **叶节点史密斯**：直接完成任务，输出结果
- **中间节点史密斯**：所有子任务完成并汇总后，输出结果
- **根史密斯**：汇总所有子结果后，输出到 `results/final.md`

禁止无限分解——每个史密斯在分解前必须评估是否真的需要分解，避免为分解而分解导致的资源浪费。
