---
name: smartsheet-write
description: 当用户请求写入数据（添加新记录或更新已有记录）时，可以使用本技能向企业微信智能表格写入数据。本技能**强制先检查并主动向用户索要** Webhook 地址和该工作表的「示例数据」schema（若缺少则立即询问并保存），之后根据 schema 精确构建 JSON payload。内置 8 个复杂度递增的完整示例、日期自动转换助手、Python requests 示例，支持所有常见字段类型。
---

# 写入数据到智能表格（Webhook）

## 概述

本技能专为企业微信智能表格「接收外部数据」功能设计，通过同一个 POST 接口完成**添加记录**或**更新记录**。
**核心原则**：没有 Webhook 地址和 schema 就无法执行。Claude 必须在任何写入操作前主动索要并保存这两个关键信息。

## 使用时机

用户说出以下记录数据类的意图时立即触发本技能：
- “帮我记录一个工单”
- “更新智能表格某条记录”
- “导入某某数据到一个表格”
- 提供具体字段值、record_id 或数据列表时

## 配置管理（每次触发必检查）

### 必备两项信息
1. **Webhook 地址**（完整含 `?key=XXX`）
2. **Schema（示例数据 JSON）**：用户从「接收外部数据」设置页复制的完整 JSON（包含字段 ID、标题、类型对应关系）

### 状态检查流程（严格执行）
1. 扫描对话历史是否已有保存的 Webhook + Schema。
2. 若缺失，**立即停止**并发送以下标准消息：
   ```
   【配置缺失】要写入智能表格，必须先创建一个智能表格，然后提供：
   1. 该工作表的完整 Webhook 地址（直接粘贴）
   2. 该工作表的「示例数据」schema（操作：智能表格 → 右上角/工作表菜单 → 「接收外部数据」→ 选择工作表 → 复制「示例数据」整个 JSON）

   请提供后我将立即保存并开始构建。
   ```
3. 用户提供后，**完整复述并确认保存**：
   ```
   ✅ 配置已保存（本对话永久有效）：
   - Webhook: https://qyapi.weixin.qq.com/...（已记录）
   - Schema: 已记录 字段ID → 类型/标题映射（列出前 5 个供确认）

   如需切换工作表，请说“切换智能表格”并重新提供。
   ```
4. 建议用户把 Claude 的确认消息复制保存到笔记。

## 安全与限流提醒（每次使用必复述）

- 任何人拥有 Webhook 地址即可写入 → 务必保密，建议开启 IP 白名单。
- 仅能更新「通过 Webhook 写入的记录」，无法更新人工创建的记录。
- 频率限制：
  - 单工作表：≤ 3000 条/分钟
  - 单文档：≤ 10000 条/分钟

## 字段值格式规则（通用，必严格遵守）

| 字段类型     | value 示例                                      | 推荐写法 |
|--------------|--------------------------------------------------|----------|
| 文本         | `"张三"` 或 `[{"type":"text","text":"张三"}]`   | 简单字符串 |
| 数字/进度/百分数/货币 | `85.5`                                    | double |
| 复选框       | `true`                                           | bool |
| 日期         | `"1735660800000"`                                | 毫秒级字符串 |
| 成员         | `[{"user_id":"USERID"}]` 或 `["张三"]`          | 优先 userid |
| 单选/多选    | `[{"text":"已完成"}]`                            | 数组 |
| 链接         | `[{"text":"文档","link":"https://..."}]`         | 数组 |
| 地理位置     | `[{"latitude":"23.10647",...,"source_type":1}]`  | 数组≤1 |
| 图片         | `[{"title":"xx.png","image_base64":"data:image..."}]` | base64 |
| 电话/邮箱/条码 | `"13800138000"`                                | 字符串 |

**不支持**：公式、自动编号、查找引用、关联、创建/最后编辑人时间、群聊、文件。

## 日期自动转换助手

用户常说“今天”“明天”“2025-03-01 09:00” → 自动转为毫秒时间戳：
- 示例：2025-03-01 09:00 → 1740806400000

## 字段映射速查表

- 用户说“姓名/名字” → 找 schema 中标题含“姓名”“名称”的字段 ID
- 用户说“状态/进度” → 找“状态”“进度”字段
- 用户直接给“fABC123: 85” → 直接使用该 ID

## 示例集（8 个真实场景）

**示例 1：最简单单条（文本 + 数字 + 单选）**
```json
{
  "add_records": [
    {
      "values": {
        "fzZhMz": "张三周报",
        "fPmvPK": 85,
        "faFo6H": [{"text": "已完成"}]
      }
    }
  ]
}
```

**示例 2：含日期（自然语言转换）**
```json
{
  "add_records": [
    {
      "values": {
        "f3cPIn": "1740806400000",
        "fzZhMz": "项目启动会议"
      }
    }
  ]
}
```

**示例 3：成员 + 多选**
```json
{
  "add_records": [
    {
      "values": {
        "f0mWTG": ["USERID_001"],
        "多选字段": [{"text": "前端"},{"text": "后端"}]
      }
    }
  ]
}
```

**示例 4：链接 + 地理位置**
```json
{
  "add_records": [
    {
      "values": {
        "链接字段": [{"text": "需求文档","link": "https://doc.example.com"}],
        "地理位置": [{"latitude": "23.10647","longitude": "113.32446","source_type":1,"title": "广州塔"}]
      }
    }
  ]
}
```

**示例 5：批量添加 3 条**
```json
{
  "add_records": [
    {"values": {"fzZhMz": "项目A","fPmvPK": 90}},
    {"values": {"fzZhMz": "项目B","fPmvPK": 75}},
    {"values": {"fzZhMz": "项目C","faFo6H": [{"text": "进行中"}]}}
  ]
}
```

**示例 6：单条更新**
```json
{
  "update_records": [
    {
      "record_id": "REC_987654",
      "values": {
        "fzZhMz": "张三修改后周报",
        "fPmvPK": 92
      }
    }
  ]
}
```

**示例 7：批量更新**
```json
{
  "update_records": [
    {"record_id": "REC_001", "values": {"状态": [{"text": "已审核"}], "负责人": [{"user_id": "USERID_002"}]}},
    {"record_id": "REC_002", "values": {"进度": 100}}
  ]
}
```

**示例 8：含图片**
```json
{
  "add_records": [
    {
      "values": {
        "fzZhMz": "带图记录",
        "图片字段": [{"title": "现场照片.png","image_base64": "iVBORw0KGgoAAAANSUhEUg...（完整base64）"}]
      }
    }
  ]
}
```

## 执行方式

**curl（推荐）**
```bash
curl '你的Webhook地址' \
  -H 'Content-Type: application/json' \
  -d '上面完整的JSON'
```

**Python requests**
```python
import requests
payload = { ...上面JSON... }
r = requests.post("你的Webhook地址", json=payload)
print(r.json())
```

## 完整使用流程总结

1. 配置检查 → 索要并保存 Webhook + Schema
2. 用户给数据 → Claude 匹配 schema → 输出完整 payload + curl/Python 示例
3. 用户执行 → 反馈 errcode 与成功记录数
4. 如需批量或重复，复用已保存配置
