---
name: smart-meme-generator
description: AI-powered meme generator that creates perfect, context-aware memes from any topic or situation. Use when user wants to create memes, needs reaction images, wants to make jokes visual, or needs viral social media content. Automatically selects optimal meme templates and generates witty captions based on context.
---

# Smart Meme Generator 🎭

Generate actual meme images from any topic. Uses imgflip API (free) for real image generation — returns shareable URLs.

## How It Works

Two-step process:
1. **Template selection** — analyzes topic keywords to pick the best meme format
2. **Image generation** — creates the actual meme image with your captions via imgflip API

The agent (you) provides the creative captions. The script handles template matching and image creation.

## Commands

### Select best template for a topic
```bash
python3 scripts/generate_meme.py "your topic here"
```
Returns recommended template and box count.

### Generate actual meme image
```bash
python3 scripts/generate_meme.py --template drake --captions "Bad option" "Good option"
```
Returns a real image URL (e.g., `https://i.imgflip.com/xxxxx.jpg`).

### List all templates
```bash
python3 scripts/generate_meme.py --list
```

### JSON output (for automation)
```bash
python3 scripts/generate_meme.py --template drake --captions "text1" "text2" --json
```

## Available Templates (20+)

| Key | Name | Boxes | Best For |
|-----|------|-------|----------|
| drake | Drake Hotline Bling | 2 | Comparisons, preferences |
| distracted | Distracted Boyfriend | 3 | Temptation, switching loyalties |
| fine | This Is Fine | 2 | Chaos, denial, everything's broken |
| brain | Expanding Brain | 4 | Escalating levels, galaxy brain takes |
| cat | Woman Yelling at Cat | 2 | Arguments, confusion |
| change | Change My Mind | 1 | Hot takes, controversial opinions |
| buttons | Two Buttons | 3 | Impossible choices, dilemmas |
| pikachu | Surprised Pikachu | 2 | Obvious/predictable outcomes |
| stonks | Stonks | 1 | Money, trading, crypto |
| panik | Panik Kalm Panik | 3 | Panic-relief-panic sequences |
| buff_doge | Buff Doge vs Cheems | 4 | Then vs now comparisons |
| uno | UNO Draw 25 | 2 | Refusing to do something |
| always_has_been | Always Has Been | 2 | Revelations |
| gru_plan | Gru's Plan | 4 | Plans that backfire |
| trade_offer | Trade Offer | 3 | Deals, exchanges |
| bernie | Bernie Asking | 1 | Repeated requests |
| left_exit | Left Exit Off Ramp | 3 | Ignoring the obvious choice |
| disaster_girl | Disaster Girl | 2 | Evil satisfaction |
| hide_pain | Hide the Pain Harold | 2 | Pretending everything's OK |
| think_about_it | Think About It | 2 | Big brain logic |

## Workflow for Agent

When user asks for a meme:
1. Run template selection with their topic to get the best format
2. Write witty, specific captions that fit the template (be creative, match internet humor)
3. Generate the image with `--captions`
4. Send the image URL to the user

**Caption tips:**
- Keep text SHORT — memes aren't essays
- Use internet humor conventions (lowercase, no periods, specific > generic)
- Match the template's energy (drake = preference, pikachu = obvious outcome, etc.)
- Be specific to the topic — generic captions are never funny

## Setup

The skill ships with a free imgflip account. To use your own:
```bash
export IMGFLIP_USER="your_username"
export IMGFLIP_PASS="your_password"
```
Register free at https://imgflip.com/signup

## Dependencies
None — pure Python stdlib (urllib only).
