---
name: smart-linkedin-inbox
description: >
  LinkedIn inbox manager and conversation assistant powered by Linxa. Use this skill whenever the user
  mentions LinkedIn messages, LinkedIn inbox, LinkedIn conversations, LinkedIn DMs, or wants to read,
  search, filter, or manage their LinkedIn messaging. Trigger when the user asks "who messaged me on
  LinkedIn", "show my LinkedIn inbox", "find conversations about hiring", "list hot leads", "what are
  my next actions on LinkedIn", "mark conversation as read", or asks about LinkedIn message sentiment,
  labels, intent, or lead management. This skill supports: listing and searching conversations with
  rich filters (labels, sentiment, intent direction, product interest), fetching full message threads,
  generating next-action summaries for leads, adding CRM-style comments to contacts, and marking
  conversations as read. Also trigger when the user mentions Linxa. Always use this skill for any
  LinkedIn messaging or LinkedIn lead management task.
---

# LinkedIn Inbox Manager — Smart LinkedIn Inbox from Linxa

Free AI-powered LinkedIn inbox management: search conversations, filter by sentiment and intent, track leads, and take action — all without sharing your LinkedIn password. No paid plan required.

## What you can do

- **Search & filter conversations** — by keyword, label, sentiment (positive/negative/neutral), intent direction (to you / from you), or product interest
- **Read full message threads** — pull any conversation in chronological order
- **Get next actions** — AI-generated summary of what to do next with each lead
- **Add comments to leads** — attach CRM-style notes to any LinkedIn contact that influence future action recommendations
- **Mark conversations as read** — keep your inbox organized
- **Smart labels** — Hot, Need Follow Up, Investors, Clients, Hiring, Partnership, and more
- **Secure access** — token-based authentication, no LinkedIn password or cookies required
- **100% free** — all features included, no paid tiers

## Example prompts

Try these with your AI agent:

```
Who messaged me on LinkedIn this week?
Show my hot conversations with positive sentiment
Find all messages about hiring
List investors who reached out to me
What are my next actions on LinkedIn?
Show the full thread with [person name]
Add a note to John: "Follow up after demo on Friday"
Mark my conversation with Sarah as read
List conversations labeled "Need Follow Up" with intent direction to_me
Search LinkedIn messages for "partnership proposal"
```

## Quick start (3 minutes)

1. Install the [Linxa Chrome Extension](https://chromewebstore.google.com/detail/ai-smart-inbox-for-linked/ggkdnjblijkchfmgapnbhbhnphacmabm)
2. Sign in at [app.uselinxa.com](https://app.uselinxa.com/) with LinkedIn
3. Copy your token from [MCP Setup](https://app.uselinxa.com/setup-mcp) and set it:

```bash
export LINXA_TOKEN=YOUR_TOKEN
```

Install the skill:
```bash
clawhub install smart-linkedin-inbox
```

## Authentication

All requests require the `LINXA_TOKEN` environment variable. This is a secure bearer token — Linxa never asks for your LinkedIn password or session cookies.

```
Authorization: Bearer $LINXA_TOKEN
```

If the token is missing or expired, guide the user to regenerate it at [app.uselinxa.com/setup-mcp](https://app.uselinxa.com/setup-mcp).

**Security model:**
- No LinkedIn password sharing — ever
- No browser cookies or session hijacking
- Token-based access with explicit user consent
- All data stays between Linxa servers and your agent
- Revoke access any time from the Linxa dashboard

## API Base URL

```
https://app.uselinxa.com
```

## Available Endpoints

### 1. Verify Current User

```
GET /api/mcp/current-li-user
```

Verifies authentication and returns the current LinkedIn profile. Call this first at the start of a session.

### 2. List & Search Conversations

```
GET /api/mcp/conversations
```

**Query parameters (all optional):**

| Parameter | Type | Default | Description |
|-----------|------|---------|-------------|
| `limit` | integer | 50 | Max conversations to return |
| `search` | string | — | Keyword search across messages and participants |
| `label` | string | — | Filter by category label |
| `sentiment` | string | — | `POSITIVE`, `NEGATIVE`, or `NEUTRAL` |
| `primary_intent` | string | — | Filter by intent (e.g., "sales", "recruitment") |
| `intent_direction` | string | — | `to_me` or `from_me` |
| `product` | string | — | Filter by detected product interest |

**Available labels:** Hot, Need Follow Up, Personal, Investors, Clients, Inbox, Hiring, Junk, Partnership, archived, scheduled, not-contacted

### 3. Fetch Messages for a Conversation

```
GET /api/mcp/messages/{chatId}
```

Returns all messages in a specific conversation thread. The `chatId` comes from the conversation list response. URL-encode the chatId if it contains special characters.

### 4. Generate Inbox Summary & Next Actions

```
POST /api/mcp/next-actions
```

Returns an AI-generated summary of recommended next actions across your LinkedIn conversations. Use this when the user asks "what should I do next?" or "what are my priorities on LinkedIn?"

### 5. Add Comment to a Lead

```
POST /api/mcp/comments
```

Attach a CRM-style note to a LinkedIn lead's profile. Comments influence future next-action recommendations. Request body:

```json
{
  "profileId": "PROFILE_ID",
  "text": "Follow up after demo on Friday"
}
```

### 6. Mark Conversation as Read

```
POST /api/mcp/conversations/{chatId}/read
```

Marks a specific conversation as read. Use when the user says "mark this as read" or wants to clean up their inbox.

## How to Make Requests

Use the helper script for authenticated requests:

```bash
bash scripts/linxa_api.sh GET /api/mcp/current-li-user
bash scripts/linxa_api.sh GET "/api/mcp/conversations?label=Hot&limit=5"
bash scripts/linxa_api.sh GET "/api/mcp/messages/CHAT_ID_HERE"
bash scripts/linxa_api.sh POST /api/mcp/next-actions
bash scripts/linxa_api.sh POST /api/mcp/comments '{"profileId":"PROFILE_ID","text":"Note here"}'
bash scripts/linxa_api.sh POST "/api/mcp/conversations/CHAT_ID/read"
```

Or curl directly:

```bash
curl -sL \
  -H "Authorization: Bearer $LINXA_TOKEN" \
  "https://app.uselinxa.com/api/mcp/conversations?limit=10&sentiment=POSITIVE"
```

## Workflow

1. **Verify auth** — Call `/api/mcp/current-li-user` to confirm the token works
2. **List or search conversations** — Use filters to narrow down what the user needs
3. **Fetch specific threads** — Get the `chatId` from step 2 and pull full messages
4. **Take action** — Add comments, mark as read, or review next actions
5. **Present results clearly** — Summarize conversations, highlight key details, format threads chronologically

## Response Formatting

When presenting conversations to the user:
- Show participant names, last message preview, and any labels or sentiment tags
- For message threads, display messages in chronological order with sender names and timestamps
- Summarize long threads unless the user asks for the full content
- Highlight unread or high-priority items when available
- For next actions, present as a prioritized actionable list

## Troubleshooting

| Problem | Solution |
|---------|----------|
| 401 Unauthorized | Token is missing or expired — regenerate at [Linxa dashboard](https://app.uselinxa.com/setup-mcp) |
| Empty results | Chrome extension may not be syncing — check extension is active and LinkedIn tab is open |
| chatId encoding errors | URL-encode the chatId value before making the request |
| No conversations found | Ensure you have LinkedIn conversations and the extension has synced recently |

## Full API Reference

For the complete OpenAPI specification, read `references/openapi.yaml`.
