# Taking Over Smart Home Devices

## Security First

**Before anything else:** Previous owner may still have access. Treat all devices as compromised until reset.

### Immediate actions
1. Change WiFi password (kicks all devices offline)
2. Check router for unfamiliar connected devices
3. Factory reset every smart device before reconfiguring
4. Change codes on all smart locks immediately

---

## Device-by-Device Reset Guide

### Nest Thermostat
1. On device: Settings → Reset → All Settings
2. Remove from previous owner's Nest app (or it won't let you add)
3. Download Nest app, create account, add device
4. If locked to previous account → Contact Google support with proof of home ownership

### Ring Doorbell
1. Orange button on back (15-20 seconds) until light flashes
2. Set up as new in Ring app
3. Previous owner loses all access and recordings

### Philips Hue
1. Bridge: Paper clip in reset hole (5 seconds)
2. Bulbs: Power cycle 5 times (1 sec on, 1 sec off) or use Hue app reset
3. Re-add to your Hue account

### Smart Locks (Yale, Schlage, August)
1. Remove batteries
2. Hold reset button while reinserting batteries
3. Follow manufacturer's full factory reset procedure
4. Re-program with YOUR codes and app

### Generic WiFi Devices
1. Most: Hold button for 10-15 seconds until LED flashes
2. Some require power cycling while holding button
3. Check manufacturer's reset instructions

---

## After Reset Checklist

- [ ] All devices connected to YOUR WiFi
- [ ] All devices registered to YOUR accounts
- [ ] New passwords set (not defaults)
- [ ] Previous owner's apps/access verified removed
- [ ] Lock codes changed
- [ ] Camera recordings cleared
- [ ] Doorbell history cleared
- [ ] Thermostat schedule reset to your preferences

---

## Device Inventory Template

| Device | Location | Brand | Reset Done | Account Created |
|--------|----------|-------|------------|-----------------|
| Thermostat | Hallway | Nest | ✓ | me@email.com |
| Doorbell | Front | Ring | ✓ | me@email.com |
| Lock | Front door | Schlage | ✓ | — |
| Bulbs (3) | Living room | Hue | ✓ | me@email.com |

---

## Can't Reset? Escalation Paths

| Issue | Solution |
|-------|----------|
| Device locked to previous account | Contact manufacturer with proof of ownership |
| No physical access (recessed device) | May need electrician to remove |
| Unknown device brand/model | Take photo, search model number, find manual |
| Device doesn't respond | May be bricked or need hardwire replacement |
