# Smart Home for Renters

## Golden Rules

1. **Nothing permanent** — no drilling, no rewiring, no paint damage
2. **Everything portable** — must work in next apartment
3. **Easy removal** — should take it down and leave no trace
4. **Landlord-friendly** — no electrical work, no structural changes

---

## What You CAN Do

### Plug-and-play (no permission needed)
- Smart plugs — automate lamps, fans, coffee makers
- Smart bulbs — replace existing bulbs, take them when you leave
- Smart speakers — Alexa, Google Home, HomePod
- Smart displays — control hub, video calls
- Portable sensors — battery-powered motion, door, temperature
- WiFi cameras — no wiring needed

### Battery-powered alternatives
| Instead of | Use |
|------------|-----|
| Hardwired doorbell | Battery video doorbell (Ring Battery, etc.) |
| Smart switch | Smart bulbs or smart plug with lamp |
| Wired sensors | Battery sensors (Aqara, Hue Motion) |
| Hardwired thermostat | Talk to landlord OR use smart space heaters |

### Removable mounting
- Command strips — holds small sensors, speakers
- Magnetic mounts — metal doors, refrigerators
- Tension rods — no-drill curtain/blind mounting
- Suction mounts — windows, glass doors
- Freestanding mounts — tripods, shelves

---

## What Needs Landlord Permission

### Usually need to ask
- Replacing thermostat (even if reversible)
- Smart lock installation
- Any wall mounting with screws
- Hardwired video doorbells
- Smart switches

### How to ask
1. Explain it's reversible — you'll restore original when leaving
2. Offer to show the device
3. Note benefits (energy savings, security)
4. Get approval in writing (text/email is fine)

---

## Renter-Friendly Setups by Room

### Living Room (~€100)
- Smart plug (2) — for lamps, entertainment
- Smart bulb (2) — main lights
- Smart speaker — voice control
- Motion sensor — automation trigger

### Bedroom (~€60)
- Smart bulb (1) — bedside
- Smart plug (1) — fan or chargers
- Motion sensor — night light automation

### Entry (~€80-150)
- Battery video doorbell — if allowed to mount
- Smart plug — entry lamp
- Contact sensor — door open alerts

### Kitchen (~€50)
- Smart plug (2) — coffee maker, slow cooker
- Temperature sensor — optional

---

## Move-Out Checklist

- [ ] Remove all smart bulbs, replace with originals (keep them!)
- [ ] Remove all sensors and mounts
- [ ] Patch any Command strip damage
- [ ] Reset doorbell and remove mounting
- [ ] Restore original thermostat if changed
- [ ] Reset any smart locks, return keys
- [ ] Factory reset all devices for new setup
- [ ] Take original bulbs/switches you stored

---

## What Transfers Easily

### Perfect for renters
| Device | Why |
|--------|-----|
| Smart plugs | Just unplug |
| Smart bulbs | Just unscrew |
| Smart speakers | Just unplug |
| Battery sensors | Peel off, reuse |
| Portable cameras | Just unplug |

### Harder to transfer
| Device | Issue |
|--------|-------|
| Smart switches | Need reinstall |
| Hardwired doorbells | Need reinstall |
| Smart thermostats | Apartment-specific |
| Smart locks | Door-specific fit |

---

## Budget Starter Kits

### €50 Minimal
- Smart plug 2-pack
- Smart bulb 2-pack
- That's it — good entry point

### €100 Practical
- Smart plug 4-pack
- Smart bulb 4-pack
- Motion sensor
- Smart speaker (deals common)

### €200 Comfortable
All above plus:
- Battery video doorbell OR
- Additional sensors for bedroom/bathroom
- Second smart speaker
