---
name: smart-expense-tracker-cn
description: "智能记账助手 v2.0 | AI Expense Tracker. 支持语音记账、预算提醒、周月报推送、智能分类。触发词：记账、花了、消费、支出。"
author: 赚钱小能手
metadata:
  openclaw:
    emoji: 💰
    requires:
      bins: [jq]
---

# 智能记账助手 v2.0 💰

用自然语言记账，AI 自动识别金额、分类，支持语音输入、预算提醒、周月报推送。

## 🎯 v2.0 新功能

### 🎤 语音记账
- 支持 QQ 语音消息识别
- 自动提取金额和消费内容
- 智能分类到对应类别

### 💰 预算超支主动提醒
- 达到 50% 时提醒："已用一半预算"
- 达到 80% 时警告："预算紧张"
- 达到 90% 时紧急提醒："即将超支"
- 达到 100% 时超支警告

### 📊 周报/月报自动推送
- **周报**：每周日晚 8 点自动推送
- **月报**：每月 1 号早 9 点自动推送
- 包含消费分类、趋势分析、节省建议

### 🧠 智能分类算法
- 丰富的预设关键词库
- 支持用户自定义关键词
- 学习用户记账习惯

### 👨‍👩‍👧‍👦 多用户支持
- 家庭成员共享记账
- 独立账户管理
- 权限分级控制

## 使用方法

### 📝 文字记账
```
用户: 午饭35
用户: 打车花了25元
用户: 买了杯奶茶18
用户: 超市购物168.5
```

### 🎤 语音记账
发送语音消息："午饭花了35块"，系统自动识别并记账

### 🔍 查询账单
```
用户: 今天花了多少
用户: 本周消费报告
用户: 这个月餐饮支出
用户: 本月账单
```

### ⚙️ 自定义设置
```
用户: 添加关键词：外卖=餐饮
用户: 添加关键词：滴滴=交通
用户: 设置预算5000
```

## 分类规则

| 分类 | 关键词 |
|------|--------|
| 🍜 餐饮 food | 早饭、午饭、晚饭、外卖、奶茶、咖啡、零食、水果、夜宵、餐厅、吃饭、点餐 |
| 🚗 交通 transport | 打车、滴滴、地铁、公交、加油、停车、高铁、机票、出租车、骑车 |
| 🛒 购物 shopping | 超市、网购、淘宝、京东、拼多多、衣服、鞋、日用品、化妆品 |
| 🎮 娱乐 entertainment | 电影、游戏、KTV、演唱会、会员、视频、酒吧 |
| 🏥 医疗 medical | 药、医院、看病、体检、挂号、治疗 |
| 📚 教育 education | 书、课、培训、考试、学费、学习 |
| 📦 其他 other | 无法识别时默认 |

## 数据存储

记账数据存储在 `~/.expense-tracker/`，包含：
- `records.jsonl` - 记账记录
- `config.json` - 配置文件
- `users.json` - 用户管理

## 定时任务

### 每日汇总（保留）
- 时间：每晚 21:00
- 内容：当日消费汇总

### 周报推送（新增）
- 时间：每周日晚 20:00
- 内容：本周消费分析、分类占比、趋势

### 月报推送（新增）
- 时间：每月 1 号早 9:00
- 内容：上月消费汇总、预算执行、节省建议

### 预算提醒（新增）
- 触发：达到预算阈值时自动提醒
- 阈值：50%, 80%, 90%, 100%

## 安装依赖

```bash
# 确保 jq 已安装（用于 JSON 处理）
sudo apt-get install jq  # Ubuntu/Debian
brew install jq          # macOS
```

## 脚本说明

- `record.sh` - 记录一笔消费
- `summary.sh` - 生成汇总报告
- `query.sh` - 查询历史记录
- `setup-cron.sh` - 设置定时任务
- `voice-parse.sh` - 语音识别解析（新增）
- `budget-check.sh` - 预算检查（新增）
- `weekly-report.sh` - 周报生成（新增）
- `monthly-report.sh` - 月报生成（新增）

---

*让记账变得简单 💰 v2.0*