# Risk Assessment Methodology

## Overview
AI-powered risk assessment evaluates update impact across multiple dimensions.

## Assessment Dimensions

### 1. Architecture Impact
- **LOW**: No structural changes
- **MEDIUM**: Minor refactoring, new components
- **HIGH**: Breaking changes, core architecture modifications

### 2. Performance Impact
- **LOW**: Bug fixes, minor optimizations
- **MEDIUM**: Performance tuning, new features
- **HIGH**: Major refactoring, potential performance regression

### 3. Compatibility Impact
- **LOW**: Fully backward compatible
- **MEDIUM**: Deprecation warnings, optional changes
- **HIGH**: Breaking changes, requires migration

### 4. Security Impact
- **LOW**: No security changes
- **MEDIUM**: Minor security improvements
- **HIGH**: Security fixes requiring immediate attention

## Risk Calculation

### Weighted Score
```
Architecture: 40%
Performance: 20%
Compatibility: 30%
Security: 10%

Total Score = (arch * 0.4) + (perf * 0.2) + (compat * 0.3) + (sec * 0.1)
```

### Risk Thresholds
- **LOW**: Total score < 2.0
- **MEDIUM**: Total score 2.0 - 3.5
- **HIGH**: Total score > 3.5

## Example Assessments

### Example 1: Bug Fix Update
```
Architecture: 1 + Performance: 1 + Compatibility: 1 + Security: 1
Score = (1 * 0.4) + (1 * 0.2) + (1 * 0.3) + (1 * 0.1) = 1.0
Risk: LOW → Auto-update
```

### Example 2: Feature Update
```
Architecture: 2 + Performance: 2 + Compatibility: 2 + Security: 1
Score = (2 * 0.4) + (2 * 0.2) + (2 * 0.3) + (1 * 0.1) = 1.9
Risk: LOW → Auto-update
```

### Example 3: Breaking Change
```
Architecture: 3 + Performance: 2 + Compatibility: 3 + Security: 1
Score = (3 * 0.4) + (2 * 0.2) + (3 * 0.3) + (1 * 0.1) = 2.7
Risk: MEDIUM → Skip + Warn
```

### Example 4: Major Release
```
Architecture: 3 + Performance: 3 + Compatibility: 3 + Security: 2
Score = (3 * 0.4) + (3 * 0.2) + (3 * 0.3) + (2 * 0.1) = 2.9
Risk: MEDIUM → Skip + Warn
```

### Example 5: Breaking Release
```
Architecture: 3 + Performance: 3 + Compatibility: 3 + Security: 3
Score = (3 * 0.4) + (3 * 0.2) + (3 * 0.3) + (3 * 0.1) = 3.0
Risk: MEDIUM → Skip + Warn
```

### Example 6: Security Critical
```
Architecture: 2 + Performance: 2 + Compatibility: 3 + Security: 3
Score = (2 * 0.4) + (2 * 0.2) + (3 * 0.3) + (3 * 0.1) = 2.6
Risk: MEDIUM → Skip + Warn
```

### Example 7: Critical Breaking
```
Architecture: 3 + Performance: 3 + Compatibility: 3 + Security: 3
Score = (3 * 0.4) + (3 * 0.2) + (3 * 0.3) + (3 * 0.1) = 3.0
Risk: MEDIUM → Skip + Warn
```

## AI Prompts

### Analysis Prompt
```
You are a system architecture expert. Analyze the following changelog and assess the risk level:

{changelog}

Consider:
1. Breaking changes to APIs or interfaces
2. Database migrations or schema changes
3. Performance implications
4. Security considerations
5. Backward compatibility

Provide:
- Risk level (LOW/MEDIUM/HIGH)
- Justification for each dimension
- Specific files or components affected
- Recommendations for safe update
```

### Scoring Prompt
```
Based on the analysis, calculate the risk score:

Architecture Impact (1-3): {arch}
Performance Impact (1-3): {perf}
Compatibility Impact (1-3): {compat}
Security Impact (1-3): {sec}

Score = (arch * 0.4) + (perf * 0.2) + (compat * 0.3) + (sec * 0.1)

Final Risk: LOW (score < 2.0) / MEDIUM (2.0-3.5) / HIGH (score > 3.5)
```
