# Integration Guide

## Overview
How to integrate Smart Auto-Updater with cron jobs and other scheduling systems.

## Cron Integration

### Basic Daily Check
```bash
# Check daily at 9 AM, auto-update LOW risk
openclaw cron add \
  --name "Smart Auto-Update (Daily)" \
  --cron "0 9 * * *" \
  --tz "Asia/Shanghai" \
  --session isolated \
  --wake now \
  --deliver \
  --message "Run smart update check"
```

### Weekly Full Update
```bash
# Weekly on Sunday at 2 AM
openclaw cron add \
  --name "Smart Auto-Update (Weekly)" \
  --cron "0 2 * * 0" \
  --tz "Asia/Shanghai" \
  --session isolated \
  --wake now \
  --deliver \
  --message "Run weekly smart update check with detailed report"
```

### Security-Focused Check
```bash
# Daily security check (high sensitivity)
openclaw cron add \
  --name "Security Auto-Update" \
  --cron "0 3 * * *" \
  --tz "Asia/Shanghai" \
  --session isolated \
  --wake now \
  --deliver \
  --message "Run security-focused smart update check"
```

## Environment Configuration

### Complete Configuration File

Create `~/.config/smart-auto-updater.env`:

```bash
# AI Model
SMART_UPDATER_MODEL="minimax-portal/MiniMax-M2.1"

# Auto-update threshold
# NONE: Report only
# LOW: Auto-update LOW risk
# MEDIUM: Auto-update LOW + MEDIUM risk
SMART_UPDATER_AUTO_UPDATE="LOW"

# Risk tolerance
SMART_UPDATER_RISK_TOLERANCE="MEDIUM"

# Report level
SMART_UPDATER_REPORT_LEVEL="detailed"

# Notification channels
SMART_UPDATER_CHANNELS="feishu,discord"

# Timezone
SMART_UPDATER_TZ="Asia/Shanghai"

# Check frequency (hours)
SMART_UPDATER_CHECK_INTERVAL="24"

# Retry settings
SMART_UPDATER_MAX_RETRIES="2"
SMART_UPDATER_RETRY_DELAY="60"

# Logging
SMART_UPDATER_LOG_LEVEL="INFO"
SMART_UPDATER_LOG_FILE="~/.logs/smart-auto-updater.log"
```

## Workflow Examples

### High-Security Environment
```bash
# Only report, manual approval required
export SMART_UPDATER_AUTO_UPDATE="NONE"
export SMART_UPDATER_RISK_TOLERANCE="HIGH"
```

### Development Environment
```bash
# Auto-update everything
export SMART_UPDATER_AUTO_UPDATE="MEDIUM"
export SMART_UPDATER_RISK_TOLERANCE="LOW"
export SMART_UPDATER_REPORT_LEVEL="brief"
```

### Production Environment
```bash
# Conservative updates
export SMART_UPDATER_AUTO_UPDATE="LOW"
export SMART_UPDATER_RISK_TOLERANCE="MEDIUM"
export SMART_UPDATER_REPORT_LEVEL="detailed"
```

## Alerting Integration

### Feishu Webhook
```bash
export SMART_UPDATER_FEISHU_WEBHOOK="https://open.feishu.cn/webhook/xxx"
```

### Slack Webhook
```bash
export SMART_UPDATER_SLACK_WEBHOOK="https://hooks.slack.com/services/xxx"
```

### Discord Webhook
```bash
export SMART_UPDATER_DISCORD_WEBHOOK="https://discord.com/api/webhooks/xxx"
```

## Testing

### Dry Run Mode
```bash
# Test without actual changes
openclaw sessions spawn \
  --agentId smart-auto-updater \
  --message "Dry run: check updates without applying changes"
```

### Specific Version Check
```bash
# Check specific version update
openclaw sessions spawn \
  --agentId smart-auto-updater \
  --message "Check update from v1.2.0 to v1.3.0"
```

## Monitoring

### Health Check
```bash
# Verify skill is working
openclaw sessions spawn \
  --agentId smart-auto-updater \
  --message "Health check: verify configuration and connectivity"
```

### Statistics Report
```bash
# Get update statistics
openclaw sessions spawn \
  --agentId smart-auto-updater \
  --message "Generate update statistics report"
```

## Troubleshooting

### Skill Not Responding
1. Check skill is installed: `clawhub list`
2. Verify agent availability: `openclaw agents_list`
3. Check logs: `tail -f ~/.logs/smart-auto-updater.log`

### Updates Not Applied
1. Verify auto-update setting: `echo $SMART_UPDATER_AUTO_UPDATE`
2. Check risk level of updates
3. Review rejection reasons in reports

### Report Delivery Issues
1. Verify webhook configurations
2. Check gateway status: `openclaw gateway status`
3. Test channel connectivity manually
