---
name: smart-auto-updater
description: Smart auto-updater with AI-powered impact assessment. Checks updates, analyzes changes, evaluates system impact, and decides whether to auto-update or just report. Perfect for hands-off maintenance with safety guarantees.
---

# Smart Auto-Updater

AI-powered auto-updater that intelligently decides whether to update based on impact assessment. Safe, intelligent, and configurable.

## What it does

### 1. Check Phase
- Checks for OpenClaw updates
- Checks for skill updates via ClawHub
- Fetches changelog and diff

### 2. AI Analysis Phase
- Analyzes changes using LLM
- Evaluates system impact (架构/性能/兼容性)
- Classifies risk level (HIGH/MEDIUM/LOW)

### 3. Decision Phase

| Risk Level | Action |
|------------|--------|
| **HIGH** | Skip update, send detailed report |
| **MEDIUM** | Skip update, send warning + report |
| **LOW** | Auto-update, send summary |

### 4. Report Phase
- Generates readable update report
- Includes risk assessment
- Provides upgrade recommendations

## Quick Start

### Basic usage
```bash
# Run smart update check
openclaw sessions spawn \
  --agentId smart-auto-updater \
  --message "Run smart update check"
```

### With custom parameters
```bash
openclaw sessions spawn \
  --agentId smart-auto-updater \
  --message "Check updates with custom settings: auto-update LOW risk, report MEDIUM risk"
```

## Configuration

### Environment Variables

```bash
# AI Model (optional, defaults to configured model)
export SMART_UPDATER_MODEL="minimax-portal/MiniMax-M2.1"

# Auto-update threshold (default: LOW)
# Options: NONE (report only), LOW, MEDIUM
export SMART_UPDATER_AUTO_UPDATE="LOW"

# Risk tolerance (default: MEDIUM)
# HIGH: Only auto-update LOW risk
# MEDIUM: Auto-update LOW + MEDIUM risk
# LOW: Auto-update all
export SMART_UPDATER_RISK_TOLERANCE="MEDIUM"

# Report level (default: detailed)
# Options: brief, detailed, full
export SMART_UPDATER_REPORT_LEVEL="detailed"
```

## Report Format

### High Risk Report
```
🔴 Smart Auto-Updater Report

Update Available: v1.2.3 → v1.3.0

⚠️ Risk Level: HIGH

📋 Changes Summary:
- Breaking API changes detected
- Database migration required
- 3 files modified

🏗️ Impact Assessment:
- Architecture: MAJOR changes to core components
- Performance: Potential impact on startup time
- Compatibility: Breaks backward compatibility

🚫 Decision: SKIPPED

💡 Recommendations:
1. Review changelog manually
2. Test in staging environment
3. Schedule maintenance window

🗓️ Next Check: 24 hours
```

### Low Risk Auto-Update
```
🟢 Smart Auto-Updater Report

Updated: v1.2.3 → v1.2.4

✅ Risk Level: LOW

📋 Changes:
- Bug fixes (2)
- Performance improvements (1)

🏗️ Impact Assessment:
- Architecture: No changes
- Performance: Minor improvement
- Compatibility: Fully compatible

✅ Decision: AUTO-UPDATED

📊 Summary:
- OpenClaw: v1.2.3 → v1.2.4
- Skills updated: 2
- Skills unchanged: 15
- Errors: none

⏱️ Next Check: 24 hours
```

## Architecture

```
┌──────────────────┐
│  Trigger (Cron)  │
└────────┬─────────┘
         │
         ▼
┌──────────────────┐
│  Check Updates    │ ← clawhub update --dry-run
└────────┬─────────┘
         │
         ▼
┌──────────────────┐
│  AI Analysis     │ ← Analyze changes, assess risk
└────────┬─────────┘
         │
    ┌────┴────┐
    │         │
    ▼         ▼
┌───────┐  ┌───────┐
│ HIGH  │  │ MEDIUM│
│ Skip  │  │ Skip  │
└───┬───┘  └───┬───┘
    │          │
    ▼          ▼
┌───────┐  ┌───────┐
│ LOW   │  │ Report│
│ Update│  │ Only  │
└───┬───┘  └───────┘
    │          │
    └────┬─────┘
         │
         ▼
┌──────────────────┐
│  Generate Report  │ ← Send summary
└──────────────────┘
```

## Safety Features

1. **Dry Run First** - Always check before acting
2. **Risk Classification** - AI-powered impact assessment
3. **Configurable Thresholds** - Set your own risk tolerance
4. **Detailed Logging** - Every decision is logged
5. **Manual Override** - Always can review before updating

## Troubleshooting

### Updates keep being skipped
- Check risk tolerance setting
- Verify AI model is available
- Review changelog manually

### False positives (too many HIGH risk)
- Lower risk tolerance
- Check AI model prompts
- Review specific change patterns

### Reports not being delivered
- Verify delivery channel configuration
- Check gateway status
- Review session configuration

## References
- `references/risk-assessment.md` → AI risk assessment methodology
- `references/report-templates.md` → Report format examples
- `references/integration.md` → Integration with cron/jobs
