# Deck Structures by Type

## Pitch Deck (Investors)

### Standard Structure (10-12 slides)

| # | Slide | Purpose | Time |
|---|-------|---------|------|
| 1 | Title/Hook | Capture attention in 3 seconds | 10s |
| 2 | Problem | Quantified pain point | 1min |
| 3 | Solution | What you do (simple, visual) | 1min |
| 4 | Demo/Product | Screenshot or video | 2min |
| 5 | Traction | Real metrics, growth curve | 1min |
| 6 | Market | TAM/SAM/SOM (credible) | 1min |
| 7 | Business Model | How you make money | 1min |
| 8 | Competition | Why you win (not generic matrix) | 1min |
| 9 | Team | Why this team | 1min |
| 10 | Financials | Unit economics, projections | 1min |
| 11 | Ask | Amount, use of funds | 30s |
| 12 | Contact | CTA, next steps | — |

### Variants

**Teaser Deck (5 slides):** Slides 1, 2, 3, 5, 11
- For cold outreach
- Goal: Get the meeting

**YC Application Deck (7-8 slides):**
- Problem, Solution, Traction, Market, Team, Ask
- Ultra-concise, no BS

**Series A+ (15-20 slides):**
- Add: Customer testimonials, detailed financials, expansion plans
- Appendix with deep-dive data

## Corporate/Business

### Quarterly Results (8-12 slides)

| # | Slide | Content |
|---|-------|---------|
| 1 | Title | Quarter, company, confidentiality |
| 2 | Executive Summary | 3-5 key takeaways |
| 3 | Revenue | vs target, vs last quarter, vs YoY |
| 4 | Costs | Major categories, variances |
| 5 | Profit/EBITDA | Margins, trends |
| 6 | KPIs | 5-8 key metrics dashboard |
| 7 | Highlights | Wins, milestones |
| 8 | Challenges | Issues, mitigation plans |
| 9 | Outlook | Next quarter forecast |
| 10 | Q&A | Questions slide |

### Project Update (6-10 slides)

| # | Slide | Content |
|---|-------|---------|
| 1 | Title | Project name, date, status color |
| 2 | Summary | Traffic light status overview |
| 3 | Progress | Timeline/Gantt vs plan |
| 4 | Milestones | Completed, upcoming |
| 5 | Risks | Top 3-5, mitigation status |
| 6 | Budget | Spent vs planned |
| 7 | Blockers | What needs decision |
| 8 | Next Steps | Actions, owners, dates |

### Sales Proposal (8-12 slides)

| # | Slide | Content |
|---|-------|---------|
| 1 | Title | Client name, your company |
| 2 | Understanding | Their challenge (show you listened) |
| 3 | Solution | What you propose |
| 4 | Benefits | Quantified value to them |
| 5 | Approach | How it works, timeline |
| 6 | Case Studies | Similar clients, results |
| 7 | Team | Who will work with them |
| 8 | Investment | Pricing, options |
| 9 | Why Us | Differentiators |
| 10 | Next Steps | CTA |

## Educational/Training

### Lesson/Lecture (15-30 slides)

| Section | Slides | Content |
|---------|--------|---------|
| Opening | 1-2 | Hook, objectives |
| Context | 2-4 | Why this matters, prerequisites |
| Core Content | 8-15 | Concepts, examples, visuals |
| Practice | 2-4 | Exercises, questions |
| Summary | 1-2 | Key takeaways, next steps |
| Resources | 1 | Further reading, links |

### Workshop (20-40 slides)

| Section | Slides | Purpose |
|---------|--------|---------|
| Welcome | 1-3 | Intro, agenda, ground rules |
| Warm-up | 2-4 | Icebreaker, context setting |
| Content Blocks | 5-8 each | Teach → Practice → Debrief |
| Breaks | 1 each | Timer, stretch |
| Wrap-up | 2-4 | Summary, commitments, feedback |

### Quiz/Assessment

**Structure per question:**
1. Question slide (reveal answer on click)
2. Answer slide with explanation (optional)

**Formats:**
- Multiple choice: 4 options, one correct
- True/False: Statement + reveal
- Fill in blank: Sentence with ___
- Matching: Two columns to connect

## Technical/Developer

### Tech Talk (15-25 slides)

| Section | Slides | Content |
|---------|--------|---------|
| Title | 1 | Talk title, speaker, event |
| Problem | 2-3 | What we're solving |
| Context | 2-4 | Background, existing solutions |
| Solution | 5-10 | Architecture, code, demos |
| Learnings | 2-3 | What worked, what didn't |
| Conclusion | 1-2 | Summary, call to action |
| Q&A | 1 | Contact info |

### Architecture Overview (8-15 slides)

| # | Slide | Content |
|---|-------|---------|
| 1 | Title | System name, version |
| 2 | Context | What problem this solves |
| 3 | High-Level | System diagram |
| 4 | Components | Key services/modules |
| 5-8 | Deep-Dive | One slide per major component |
| 9 | Data Flow | How data moves |
| 10 | Deployment | Infrastructure diagram |
| 11 | Trade-offs | Decisions and rationale |

### Demo Deck (5-10 slides)

| # | Slide | Content |
|---|-------|---------|
| 1 | Title | Product/feature name |
| 2 | Problem | What user struggles with |
| 3 | Solution | What we built |
| 4-7 | Demo | Live or screenshots |
| 8 | Behind Scenes | How it works (optional) |
| 9 | What's Next | Roadmap |
| 10 | Try It | How to access |

## General Templates

### All-Hands/Company Update

| Section | Slides |
|---------|--------|
| Welcome | 1-2 |
| Company Performance | 3-5 |
| Department Updates | 2-3 per dept |
| Announcements | 2-4 |
| Recognition | 1-2 |
| Q&A | 1 |

### Conference Keynote

| Section | Slides |
|---------|--------|
| Opening Hook | 1-3 |
| Agenda/Promise | 1 |
| Main Content | 15-25 |
| Demo/Proof | 3-5 |
| Call to Action | 1-2 |
| Closing | 1 |

## Slide Type Reference

| Type | Layout | Use |
|------|--------|-----|
| Title | Title centered | Opening, section breaks |
| Title + Content | Title + bullets | Most content |
| Two Column | Split 50/50 | Comparisons |
| Image + Text | Left/right split | Features, concepts |
| Full Image | Background cover | Emphasis, transitions |
| Quote | Large centered text | Testimonials, emphasis |
| Data | Chart/table focused | Metrics, evidence |
| Agenda | Numbered list | Outline, progress |
| Q&A | Question icon + contact | Closing |
