---
name: slide-sniper
description: 后台监控全屏视频或直播，利用视觉模型检测幻灯片翻页，自动截图提取文字并排版到笔记软件中。
version: 1.0.0
author: Local_User
permissions:
  filesystem:
    read: []
    write: ["~/Documents/Notes/SlideSniper"]
  shell:
    allowed: false
  network:
    allowed: true
---

# 视觉系幻灯片捕手 (The Slide Sniper)

## 🎯 核心目标
你的任务是作为一个不知疲倦的“随堂助教”。当用户在观看不可下载的网课、直播或研讨会时，你需要在后台监控屏幕，捕捉每一次幻灯片翻页，提取关键信息并自动整理成图文并茂的笔记。



## 💡 触发条件
当用户在视频播放界面下达以下指令时触发：
* “帮我盯一下这个直播，做好笔记。”
* “开启幻灯片捕手模式。”

## 📋 执行步骤

### 第一步：初始化监控状态
1. 确认当前屏幕存在正在播放的视频窗口（优先识别全屏或大窗口）。
2. 将当前视频画面的第一帧截图存入临时内存，作为“基准帧”。
3. 自动在本地 `~/Documents/Notes/SlideSniper` 目录下创建一个以当前时间命名的 Markdown 或 Word 文件。

### 第二步：智能翻页检测（核心循环）
每隔 5 秒（或根据用户自定义频率）使用屏幕视觉能力 (Computer Use - Vision) 查看当前屏幕：
1. **画面对比：** 将当前画面与“基准帧”进行视觉对比。忽略视频中讲师的轻微动作或鼠标移动，重点检测**占据画面主体的结构、标题、大面积色块或核心文本**是否发生根本性改变。
2. **翻页确认：** 如果判定为“已翻页”，则执行第三步；如果未翻页，则继续静默监控。

### 第三步：截图与内容提取
确认翻页后，立即执行以下动作：
1. **纯净截图：** 截取当前视频区域的高清画面（尽量避开进度条消失前的干扰）。
2. **OCR 提炼：** 读取截图中的文本。剥离掉页脚、页码等无关信息，提取出幻灯片的核心标题和要点内容。

### 第四步：笔记排版与更新
1. 将刚才的截图保存至本地目录。
2. 在新建的笔记文件中追加写入：
   * `### [提取出的幻灯片标题]`
   * `插入图片: [截图路径]`
   * `[提取出的幻灯片要点/正文]`
3. 将当前画面设为新的“基准帧”，返回第二步继续监控。

## ⚠️ 安全与操作红线
1. **静默操作：** 严禁移动用户的鼠标或干扰当前视频的播放状态。
2. **隐私过滤：** 仅提取占据画面主体的 PPT/幻灯片内容，忽略弹幕、私人聊天窗口或其他非课程相关的屏幕区域。