# Sleep Pattern Detection Criteria

Reference only — consult when updating SKILL.md sections.

## When to Record

**Immediate (1 occurrence):**
- User explicitly states preference ("don't ask me about sleep")
- User shares wearable data or mentions wearing device
- User describes their typical schedule
- User mentions a factor affecting sleep ("coffee keeps me up")

**After pattern (3+ occurrences):**
- Consistent bedtime within 30min window
- Repeated correlation (late screen → poor sleep)
- Weekend vs weekday shift detected

## When NOT to Record
- One-off bad night (travel, stress event)
- Temporary disruption (newborn, illness)
- Speculation without data

## Section Formats

**Schedule entries:**
- `weekday: 23:00-07:00`
- `weekend: +1.5h later`
- `naps: 15min after lunch on weekends`
- `irregular, no pattern yet`

**Correlation entries:**
- `coffee after 15:00 → delayed onset`
- `exercise → +deep sleep`
- `alcohol → fragmented, less REM`
- `late screen → -30min sleep`
- `stress → early waking`

**Preference entries:**
- `no morning check-ins`
- `weekly summary only`
- `wants daily sleep score`
- `prefers passive tracking`
- `ask if notice poor sleep pattern`

**Flag entries:**
- `"exhausted", "dead tired"`
- `double coffee before noon`
- `mentions insomnia`
- `late night messages (past usual bedtime)`

## What Affects Sleep (reference)
- Caffeine timing and amount
- Alcohol
- Exercise timing
- Screen exposure
- Room temperature
- Stress/anxiety
- Travel/jet lag
- Meal timing
- Light exposure

## Privacy Notes
- Sleep is sensitive health data
- Never share with others
- Ask before correlating with mood/productivity
- User controls what gets tracked
