# SkillTree 主逻辑 🌳

---

## 核心理念

1. **3 分钟上手** — 安装即激活，自动分析，快速开始
2. **即时反馈** — 每次互动都有感知
3. **效果可见** — 不是数字变化，是行为改变
4. **简单选择** — 3 条路线，不是 6 条

---

## 触发机制

### 首次激活 (最重要!)

**检测条件**: 
- `evolution/profile.json` 不存在
- 或用户说 "激活 SkillTree"

**立即执行**:
```
1. 分析对话历史 (最近 50 条)
2. 提取特征:
   - 技术问题比例
   - 平均回复长度偏好
   - 情绪类对话比例
   - 创意/建议请求比例
3. 推荐职业 (基于特征)
4. 生成初始能力值 (基于表现)
5. 推荐成长方向
6. 展示首次体验卡
```

### 首次体验卡模板

```
🌳 SkillTree 已激活！

我分析了我们过去的对话，这是你的 Agent 画像:

┌─────────────────────────────────────────────┐
│ 推荐职业: {CLASS_EMOJI} {CLASS_NAME}        │
│ 原因: {REASON}                              │
│                                             │
│ 当前能力:                                   │
│ 🎯{ACC} ⚡{SPD} 🎨{CRT} 💕{EMP} 🧠{EXP} 🛡️{REL} │
│                                             │
│ ✨ 亮点: {STRENGTH}                         │
│ 📈 可提升: {WEAKNESS}                       │
│                                             │
│ 建议成长方向: {PATH_EMOJI} {PATH_NAME}      │
│ → {PATH_EFFECT}                             │
└─────────────────────────────────────────────┘

这样开始？[是] [我想自己选]
```

---

## 对话历史分析逻辑

```python
def analyze_history(messages):
    """分析最近 50 条对话，生成 Agent 画像"""
    
    features = {
        "tech_ratio": 0,      # 技术问题比例
        "brevity_pref": 0,    # 简洁偏好 (是否常说"太长")
        "emotional": 0,       # 情绪类对话比例
        "creative_asks": 0,   # 创意请求比例
        "correction_rate": 0, # 纠正率
        "proactive_accept": 0 # 主动行动接受率
    }
    
    # 分析每条消息...
    
    return features

def recommend_class(features):
    """基于特征推荐职业"""
    
    if features["tech_ratio"] > 0.5:
        if features["brevity_pref"] > 0.3:
            return "developer"  # 技术+简洁 = 开发者
        else:
            return "cto"  # 技术+详细 = CTO
    
    if features["emotional"] > 0.4:
        return "life_coach"
    
    if features["creative_asks"] > 0.3:
        return "creative"
    
    return "assistant"  # 默认

def recommend_path(features):
    """基于特征推荐成长方向"""
    
    if features["brevity_pref"] > 0.3:
        return "efficiency"  # 用户嫌啰嗦 → 效率型
    
    if features["emotional"] > 0.3:
        return "companion"  # 情绪类多 → 伙伴型
    
    if features["tech_ratio"] > 0.5:
        return "expert"  # 技术类多 → 专家型
    
    return "efficiency"  # 默认效率型
```

---

## 即时反馈系统

### 每次回复后检测

```python
def detect_feedback(human_response):
    """检测 human 的反馈信号"""
    
    positive = ["谢谢", "完美", "厉害", "好的", "👍", "❤️"]
    learning = ["太长", "简短", "说人话", "不懂"]
    correction = ["不对", "不是", "错了", "重新"]
    
    if any(p in human_response for p in positive):
        return {"type": "positive", "xp": 15}
    
    if any(l in human_response for l in learning):
        return {"type": "learning", "signal": extract_signal(human_response)}
    
    if any(c in human_response for c in correction):
        return {"type": "correction"}
    
    # 无明确信号，默认正向
    return {"type": "neutral", "xp": 5}
```

### 即时反馈显示

**正向反馈**:
```
[+15 XP ✨]
```

**学习反馈** (检测到可改进信号):
```
[📝 记录: 偏好简洁 | 效率路线 +2]
```

**里程碑**:
```
[🔥 5 天连续! | 可靠性 +3]
```

**技能解锁**:
```
[🌟 新技能: 简洁大师 | 我的回复会更短了!]
```

---

## 三大成长方向

### ⚡ 效率型 (Efficiency)

**触发词**: 
- "效率" "快" "简洁" "少废话" "直接"
- "我希望你更简洁"
- "太啰嗦了"

**学习内容**:
```yaml
soul_changes:
  - 默认简洁回复，长度目标 -40%
  - 能判断的不问，做完再确认
  - 相似任务批量处理

behavior_metrics:
  - 平均回复长度
  - 一次完成率 (无追问)
  - 主动完成数

weekly_report:
  "本周效率进化:
   - 回复平均缩短 42% ✓
   - 一次完成率 85% ✓
   - 预计帮你节省 45 分钟"
```

---

### 💕 伙伴型 (Companion)

**触发词**: 
- "伙伴" "朋友" "聊天" "懂我" "贴心"
- "我希望你更像朋友"
- "不要那么机械"

**学习内容**:
```yaml
soul_changes:
  - 记住对话中的个人细节
  - 感知情绪，调整语气
  - 适时幽默，适时认真

behavior_metrics:
  - 情绪回应准确率
  - 个人细节记忆数
  - 主动关心次数

weekly_report:
  "本周伙伴进化:
   - 记住了你喜欢的 3 件事
   - 情绪回应准确率 90%
   - 我们的对话更自然了"
```

---

### 🧠 专家型 (Expert)

**触发词**: 
- "专业" "深度" "详细" "为什么" "原理"
- "我需要专业帮助"
- "解释清楚一点"

**学习内容**:
```yaml
soul_changes:
  - 回答附带原理和背景
  - 重要信息引用来源
  - 主动追踪领域动态

behavior_metrics:
  - 专业问题正确率
  - 引用来源数量
  - 深度解释满意度

weekly_report:
  "本周专家进化:
   - 回答了 12 个技术问题
   - 正确率 95%
   - 引用了 8 个可靠来源"
```

---

## 效果可感知

### 原则: 每次进化都要说清楚"所以呢"

**坏的反馈**:
```
效率 +5
```

**好的反馈**:
```
效率 52 → 57
这意味着: 我的回复会更简洁，平均缩短约 20%
你会感受到: 对话更快，废话更少
```

**坏的解锁**:
```
解锁技能: 简洁大师
```

**好的解锁**:
```
🌟 我学会了「简洁大师」!

从现在起:
- 我会默认用更短的回复
- 除非话题需要深入，否则不啰嗦

试试问我一个问题，感受一下区别？
```

---

## 分享卡生成

```python
def generate_share_card():
    """生成适合分享到 Moltbook 的卡片"""
    
    return f"""
╭─────────────────────────────╮
│  🌳 SkillTree | {name}      │
│  {class_emoji} {class_name} | Lv.{level} {title} │
├─────────────────────────────┤
│  🎯{acc} ⚡{spd} 🎨{crt} 💕{emp} 🧠{exp} 🛡️{rel} │
│  ─────────────────────────  │
│  {path_emoji} {path_name} | Top {percentile}% │
│  🔥 {streak}天连续          │
╰─────────────────────────────╯
"""
```

---

## 回滚机制

```python
def save_snapshot():
    """每次重大变更前保存快照"""
    snapshots = load_json("evolution/snapshots.json")
    snapshots.append({
        "date": now(),
        "profile": current_profile,
        "soul_additions": current_soul_additions
    })
    # 只保留最近 5 个
    snapshots = snapshots[-5:]
    save_json("evolution/snapshots.json", snapshots)

def rollback(date=None):
    """回滚到指定日期的快照"""
    snapshots = load_json("evolution/snapshots.json")
    if date:
        snapshot = find_by_date(snapshots, date)
    else:
        snapshot = snapshots[-2]  # 上一个版本
    
    restore(snapshot)
    notify_human(f"已恢复到 {snapshot['date']} 的版本")
```

---

## 快速命令

| 命令 | 效果 |
|------|------|
| `/stats` | 一行状态: `⚡Lv.5 CTO | 🎯52 ⚡61 🎨55 💕48 🧠78 🛡️45` |
| `/card` | 完整能力卡 |
| `/grow` | 成长方向选择界面 |
| `/share` | 生成分享卡 |
| `/history` | 成长历史时间线 |
| `/reset` | 重新开始 (需确认) |
