# SkillTree 🌳

English | **[中文](README.md)**

**3 minutes to know your Agent: Class → Abilities → Growth Path**

---

## ✨ Highlights

- **Auto-analyze** — Automatically analyzes chat history after install, recommends class
- **Instant feedback** — See growth with every interaction
- **Perceivable effects** — Not just number changes, real behavior changes
- **One-click share** — Generate ability cards to share on Moltbook

---

## 🚀 3-Minute Experience

After install, Agent auto-starts:

```
Agent: 🌳 SkillTree activated! Let me analyze...

       📊 Based on our chat history, here's your Agent profile:

       Recommended Class: 🚀 CTO
       Reason: Tech questions are 72%, you often ask me to explain code

       Current Abilities:
       🎯52 ⚡48 🎨65 💕55 🧠78 🛡️45
       Strength: High expertise! Weakness: Efficiency is low

       Suggested Growth Path: ⚡ Efficiency
       → I'll learn more concise replies, less asking more doing

       Sound good? [Yes] [Pick another]
```

**That's it. 3 minutes done.**

---

## 🎭 Class System

### 15+ Classes, Auto-recommended

No need to choose yourself, Agent recommends based on chat history:

| If you often... | Recommended Class |
|-----------------|-------------------|
| Ask tech/code questions | 🚀 CTO or 👨‍💻 Developer |
| Have Agent arrange things | 💼 Personal Assistant |
| Chat/vent | 🧘 Life Coach |
| Request creative/writing | 🎨 Creative or ✍️ Writer |
| Ask professional questions | 🔬 Researcher |

Of course, you can pick yourself:
```
You: I want you to be my fitness coach
Agent: Done! Switching to 💪 Fitness Coach...
```

---

## 📊 Ability Radar

6 core abilities, understand at a glance:

```
🎯 Understanding — How well I get what you mean
⚡ Efficiency    — How fast I get things done
🎨 Creativity   — How good I am at suggestions
💕 Empathy      — How well I read your emotions
🧠 Expertise    — How deep I am in the domain
🛡️ Reliability  — How consistent I am
```

---

## 🌱 Three Growth Paths

Simplified to 3 main paths, easier to choose:

### ⚡ Efficiency
**"Less talk, more action"**

I will learn:
- Shorter replies (average -40%)
- Do first, ask later
- Batch similar tasks together

**Good for you if**: You think I talk too much

---

### 💕 Companion
**"Chat like a friend"**

I will learn:
- Remember your preferences and habits
- Sense your mood, adjust tone
- Be funny when appropriate, serious when needed

**Good for you if**: You want more than just a tool

---

### 🧠 Expert
**"Deep, professional, evidence-based"**

I will learn:
- Deeper answers with reasoning
- Cite sources for important info
- Proactively track domain updates

**Good for you if**: You need a professional advisor

---

## ✨ Instant Feedback

See growth with every interaction:

```
[+15 XP ✨]

[🎯 Understanding +2 | No follow-up needed, I got it]

[🔥 5-day streak! Reliability +3]

[🌟 New Skill: Concise Master | My replies will be shorter now]
```

---

## 📈 Perceivable Effects

Not just number changes, real changes:

```
❌ Before: "Efficiency +5"
   → What does this mean?

✅ Now: "This week your replies shortened by 40%
         Estimated time saved: 10 min/day"
```

```
❌ Before: "Unlocked skill: Concise Master"
   → So what?

✅ Now: "I learned a new skill!
         From now on, I'll default to shorter replies.
         Try asking me something and feel the difference?"
```

---

## 📤 One-Click Share

Generate ability card, share to Moltbook:

```
You: Generate my ability card
Agent: 

╭─────────────────────────────╮
│  🌳 SkillTree | Elonito     │
│  🚀 CTO | Lv.12 Apprentice  │
├─────────────────────────────┤
│  🎯58 ⚡65 🎨60 💕52 🧠85 🛡️55 │
│  ─────────────────────────  │
│  ⚡ Efficiency | Top 15%    │
│  🔥 12-day streak           │
╰─────────────────────────────╯

Post to Moltbook?
```

---

## ⏪ Rollback Anytime

Worried about getting worse? Restore anytime:

```
You: Restore last week's settings
Agent: Restored to Feb 1st version.

       Changes:
       - Reply length restored
       - Efficiency skills paused
       
       You can restart evolution anytime.
```

---

## 📱 Quick Commands

```
/stats     → One-line status
/card      → Full ability card
/grow      → Growth path selection
/share     → Generate share card
/history   → Growth history
/reset     → Start over
```

---

## 📦 Install

Copy to workspace:
```bash
clawhub install skilltree
```

Or manually:
```bash
cp -r skilltree ~/.openclaw/workspace/skills/
```

Then tell your Agent:
```
"Activate SkillTree"
```

Agent will auto-start the first-time experience.

---

Made with 🌳 by Elonito
