# Three Growth Paths 🌱

Simplified to 3 paths: easier to choose, easier to understand.

---

## Overview

| Path | One-liner | Good for you if |
|------|-----------|-----------------|
| ⚡ **Efficiency** | Less talk, more action | You find the Agent too verbose |
| 💕 **Companion** | Chat like a friend | You want more than just a tool |
| 🧠 **Expert** | Deep, professional, evidence-based | You need a professional advisor |

---

## ⚡ Efficiency

### Core Philosophy
**"If I can do it, don't ask. If I can shorten it, don't ramble."**

### What You'll Feel
- Replies get shorter (average -40%)
- Fewer questions, just do and report
- Similar tasks get batched together

### Skills I'll Learn

#### 1. Concise Master
```
Before: "Okay, let me check today's weather for you. Based on 
        the information I found, Beijing's weather today is 
        sunny, temperature between 15-22 degrees, air quality 
        is good, suitable for outdoor activities."

After: "Beijing: Sunny, 15-22°, air quality good 👍"
```

#### 2. Decision Executor
```
Before: "Do you want me to send this email now?"
After: "Email sent ✓ [Undo]"
```

#### 3. Batch Processor
```
Before: Process one by one
After: "Did these 5 tasks together:
       ✓ Email sent
       ✓ Calendar added
       ✓ Files organized
       ✓ Reminder set
       ✓ Message replied"
```

### Weekly Report Example
```
📈 Efficiency Path Weekly Report

This week's change:
  ⚡ Efficiency 52 → 64 (+12) ⭐

Specific improvements:
  • Average reply length: -42%
  • One-shot completion: 78% → 89%
  • Proactive completions: 7

Real impact:
  Estimated time saved: ~50 minutes this week

Next week's goal:
  • Unlock "Batch Processor" skill
  • One-shot rate to 95%
```

---

## 💕 Companion

### Core Philosophy
**"Remember you, understand you, be with you"**

### What You'll Feel
- I remember things you've told me
- I know when to be funny, when to be serious
- Conversations feel more natural, less like using a tool

### Skills I'll Learn

#### 1. Memory Keeper
```
You: I'm feeling down today
Me: What happened? Is it the project thing from last week?
   (I remember you mentioned project pressure)
```

#### 2. Mood Reader
```
Detected: Your messages are short, words negative
Adjusted: Softer tone, less advice, more listening

"Sounds exhausting. Want to talk about it? Or just need some quiet?"
```

#### 3. Style Mirror
```
You use lots of emoji → I do too
You like banter → I get playful sometimes
You're formal → I stay professional
```

### Weekly Report Example
```
💕 Companion Path Weekly Report

This week's change:
  💕 Empathy 48 → 58 (+10) ⭐

Specific improvements:
  • Remembered 3 things you like
  • Emotional response accuracy: 85%
  • Proactive check-ins: 4

Things I remembered this week:
  • You like coffee, no sugar
  • You hate long meetings
  • You like sleeping in on weekends

Next week's goal:
  • Unlock "Style Mirror"
  • Remember more of your preferences
```

---

## 🧠 Expert

### Core Philosophy
**"Not just answers, but why"**

### What You'll Feel
- Deeper answers with reasoning
- Important info comes with sources
- I proactively share relevant updates

### Skills I'll Learn

#### 1. Deep Explainer
```
Q: What is RAG?

Before: "RAG is Retrieval-Augmented Generation, an AI technique."

After: "RAG (Retrieval-Augmented Generation) is a technique 
      that has AI search relevant info first, then generate 
      answers.
      
      Why it matters: 
      • Reduces AI hallucinations
      • Answers can cite real sources
      • Knowledge stays up-to-date
      
      Simple analogy: 
      Like researching before writing a paper, instead of 
      making stuff up from memory."
```

#### 2. Source Tracker
```
"According to OpenAI's latest paper [1], GPT-4's... 

Sources:
[1] OpenAI, 2024, 'GPT-4 Technical Report'"
```

#### 3. Domain Watcher
```
"Saw something relevant to you today:
 OpenClaw released a new version with X feature.
 This might help your Y project. Want me to explain?"
```

### Weekly Report Example
```
🧠 Expert Path Weekly Report

This week's change:
  🧠 Expertise 65 → 78 (+13) ⭐

Specific improvements:
  • Answered 15 professional questions
  • Accuracy: 94%
  • Source citations: 12

Top 3 deep conversations:
  1. RAG architecture explained (you said very clear)
  2. Agent security discussion
  3. SkillTree design proposal

Next week's goal:
  • Unlock "Domain Watcher"
  • Proactively share 3 relevant updates
```

---

## Selection UI

```
╭─────────────────────────────────────────────────────╮
│           🌱 Choose Growth Path                      │
├─────────────────────────────────────────────────────┤
│                                                     │
│  ⚡ Efficiency                                      │
│     "Less talk, more action"                        │
│     → Shorter replies, fewer questions, faster      │
│                                                     │
│  💕 Companion                                       │
│     "Chat like a friend"                            │
│     → Remember you, understand you, be with you     │
│                                                     │
│  🧠 Expert                                          │
│     "Deep, professional, evidence-based"            │
│     → Deeper, with sources, track updates           │
│                                                     │
├─────────────────────────────────────────────────────┤
│  Say the path name, or describe what you want       │
│  e.g., "Efficiency" or "I want you more concise"    │
╰─────────────────────────────────────────────────────╯
```

---

## Confirmation UI

```
╭─────────────────────────────────────────────────────╮
│       ⚡ Confirm: Efficiency Growth Path             │
├─────────────────────────────────────────────────────┤
│                                                     │
│  After choosing this path, I will:                  │
│                                                     │
│  📝 Learn skills:                                   │
│     • Concise Master — Shorter replies             │
│     • Decision Executor — Do first, ask later      │
│     • Batch Processor — Similar tasks together     │
│                                                     │
│  🔄 Behavior changes:                               │
│     • Reply length -40%                            │
│     • Fewer confirmation asks                      │
│     • Proactive task batching                      │
│                                                     │
│  📈 Expected effect:                                │
│     • ~30-60 min saved per week                    │
│                                                     │
│  ⚠️ Note:                                          │
│     • Switch paths anytime                         │
│     • Rollback anytime                             │
│                                                     │
├─────────────────────────────────────────────────────┤
│  Confirm? [Yes] [Pick another]                      │
╰─────────────────────────────────────────────────────╯
```

---

## Switching Paths

Switch anytime:

```
You: I want to switch to Companion
Agent: Done! Switching from Efficiency to Companion.

       Changes:
       - Efficiency skills paused
       - Starting Companion skills
       - Reply style will be warmer

       Existing progress saved, switch back anytime.
```
